/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.ext.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import com.sonatype.nexus.licensing.ext.internal.MultiProductPreferenceFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.ProductLicenseManager;
import org.sonatype.licensing.product.util.LicenseContent;
import org.sonatype.licensing.product.util.LicenseFingerprinter;
import org.sonatype.nexus.common.app.ApplicationDirectories;

@Named
@Singleton
public class NexusLicenseManager
extends ComponentSupport
implements LicenseManager {
    private final ProductLicenseManager licenseManager;
    private final Feature proFeature;
    private final Feature proStarterFeature;
    private final MultiProductPreferenceFactory productPreferenceFactory;
    private final LicenseFingerprinter licenseFingerprinter;
    private final LicenseContent licenseContent;
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public NexusLicenseManager(ProductLicenseManager licenseManager, LicenseFingerprinter licenseFingerprinter, LicenseContent licenseContent, @Named(value="NexusProfessional") @Named(value="NexusProfessional") Feature proFeature, @Named(value="NexusStarter") @Named(value="NexusStarter") Feature proStarterFeature, MultiProductPreferenceFactory productPreferenceFactory, ApplicationDirectories applicationDirectories) {
        this.licenseManager = (ProductLicenseManager)Preconditions.checkNotNull((Object)licenseManager);
        this.licenseFingerprinter = (LicenseFingerprinter)Preconditions.checkNotNull((Object)licenseFingerprinter);
        this.licenseContent = (LicenseContent)Preconditions.checkNotNull((Object)licenseContent);
        this.proFeature = (Feature)Preconditions.checkNotNull((Object)proFeature);
        this.proStarterFeature = (Feature)Preconditions.checkNotNull((Object)proStarterFeature);
        this.productPreferenceFactory = (MultiProductPreferenceFactory)Preconditions.checkNotNull((Object)productPreferenceFactory);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    @Override
    public void installLicense(byte[] licenseFile) throws IOException {
        ProductLicenseKey license = this.licenseManager.getLicenseDetails((InputStream)new ByteArrayInputStream(licenseFile));
        if (!this.isLicenseApplicable(license)) {
            throw new LicensingException("Invalid license");
        }
        String licenseProduct = this.getLicenseProduct(license);
        this.productPreferenceFactory.setProduct(licenseProduct);
        this.licenseManager.installLicense((InputStream)new ByteArrayInputStream(licenseFile));
        this.markEdition(licenseProduct);
    }

    private boolean isLicenseApplicable(ProductLicenseKey licenseKey) {
        return licenseKey.getFeatureSet().hasFeature(this.proFeature) || licenseKey.getFeatureSet().hasFeature(this.proStarterFeature);
    }

    private String getLicenseProduct(ProductLicenseKey productLicenseKey) {
        if (productLicenseKey.getFeatureSet().hasFeature(this.proFeature)) {
            return "PRO";
        }
        if (productLicenseKey.getFeatureSet().hasFeature(this.proStarterFeature)) {
            return "PRO-STARTER";
        }
        return null;
    }

    @Override
    public void uninstallLicense() {
        String licenseProduct = this.getLicenseProduct(this.getLicenseDetails());
        this.licenseManager.uninstallLicense();
        this.unmarkEdition(licenseProduct);
    }

    @Override
    public ProductLicenseKey getLicenseDetails() {
        return this.licenseManager.getLicenseDetails();
    }

    @Override
    public ProductLicenseKey getLicenseDetails(InputStream licenseFile) throws IOException {
        return this.licenseManager.getLicenseDetails(licenseFile);
    }

    @Override
    public String getLicenseFingerprint() {
        return this.licenseFingerprinter.calculate();
    }

    @Override
    public byte[] getLicenseFile() {
        return this.licenseContent.raw();
    }

    private File getEditionMarkerFile(String licenseProduct) {
        String filename = "edition_" + licenseProduct.toLowerCase().replace('-', '_');
        return this.applicationDirectories.getWorkDirectory().toPath().resolve(filename).toFile();
    }

    private void markEdition(String licenseProduct) {
        File marker = this.getEditionMarkerFile(licenseProduct);
        try {
            if (marker.createNewFile()) {
                this.log.debug("Created pro edition marker file: {}", (Object)marker);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create pro edition marker file: {}", (Object)marker, (Object)e);
        }
    }

    private void unmarkEdition(String licenseProduct) {
        File marker = this.getEditionMarkerFile(licenseProduct);
        if (marker.delete()) {
            this.log.debug("Deleted pro edition marker file: {}", (Object)marker);
        }
    }
}

