/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread.io;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

public class StreamCopier<T>
extends ComponentSupport {
    private static ExecutorService COMMON_SERVICE = StreamCopier.makeExecutorService();
    private static final int DEFAULT_POOL_SIZE = 100;
    private final Consumer<OutputStream> write;
    private final Function<InputStream, T> read;
    private final ExecutorService service;
    private boolean afterReadLeaveStreamsOpen;

    public StreamCopier(Consumer<OutputStream> write, Function<InputStream, T> read) {
        this(write, read, COMMON_SERVICE);
    }

    public StreamCopier(Consumer<OutputStream> write, Function<InputStream, T> read, ExecutorService service) {
        this.write = (Consumer)Preconditions.checkNotNull(write);
        this.read = (Function)Preconditions.checkNotNull(read);
        this.service = (ExecutorService)Preconditions.checkNotNull((Object)service);
    }

    public T read() {
        return this.read(60000L);
    }

    public T read(long timeoutMilliseconds) {
        try {
            return (T)this.service.submit(() -> {
                T result;
                PipedInputStream input = new PipedInputStream();
                PipedOutputStream output = new PipedOutputStream(input);
                try {
                    this.write(output);
                    result = this.read.apply(input);
                }
                catch (Exception e) {
                    this.closeStream(input);
                    throw new RuntimeException("Unable to properly read from stream", e);
                }
                return result;
            }).get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to properly read from stream", e);
        }
    }

    public StreamCopier<T> afterReadLeaveStreamsOpen() {
        this.afterReadLeaveStreamsOpen = true;
        return this;
    }

    private void write(OutputStream stream) {
        if (this.afterReadLeaveStreamsOpen) {
            this.service.execute(() -> this.write.accept(stream));
        } else {
            this.service.execute(() -> this.write.andThen(this::closeStream).accept(stream));
        }
    }

    private void closeStream(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            this.log.error("Failed to close Stream", (Throwable)e);
        }
    }

    private static ExecutorService makeExecutorService() {
        String name = StreamCopier.class.getSimpleName().toLowerCase();
        int nThreads = SystemPropertiesHelper.getInteger((String)String.join((CharSequence)".", "nexus", name, "poolSize"), (int)100);
        NexusThreadFactory factory = new NexusThreadFactory(name, name);
        ThreadPoolExecutor backing = new ThreadPoolExecutor(0, nThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory);
        return NexusExecutorService.forFixedSubject(backing, FakeAlmightySubject.TASK_SUBJECT);
    }
}

