/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.thread.internal.MDCUtils;

public class MDCAwareRunnable
implements Runnable {
    private final Runnable delegate;
    private final Map<String, String> mdcContext;

    public MDCAwareRunnable(Runnable delegate) {
        this.delegate = (Runnable)Preconditions.checkNotNull((Object)delegate);
        this.mdcContext = MDCUtils.getCopyOfContextMap();
    }

    @Override
    public void run() {
        MDCUtils.setContextMap(this.mdcContext);
        this.delegate.run();
    }
}

