/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.subject.CurrentSubjectSupplier;
import org.sonatype.nexus.thread.internal.MDCAwareCallable;
import org.sonatype.nexus.thread.internal.MDCAwareRunnable;

public class NexusExecutorService
extends SubjectAwareExecutorService {
    private final Supplier<Subject> subjectSupplier;

    public NexusExecutorService(ExecutorService target, Supplier<Subject> subjectSupplier) {
        super((ExecutorService)Preconditions.checkNotNull((Object)target));
        this.subjectSupplier = (Supplier)Preconditions.checkNotNull(subjectSupplier);
    }

    protected Subject getSubject() {
        return this.subjectSupplier.get();
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject subject = this.getSubject();
        return subject.associateWith((Runnable)new MDCAwareRunnable(r));
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject subject = this.getSubject();
        return subject.associateWith(new MDCAwareCallable<T>(task));
    }

    public static NexusExecutorService forFixedSubject(ExecutorService target, Subject subject) {
        return new NexusExecutorService(target, () -> subject);
    }

    public static NexusExecutorService forCurrentSubject(ExecutorService target) {
        return new NexusExecutorService(target, (Supplier<Subject>)new CurrentSubjectSupplier());
    }
}

