/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.thread.NexusThreadFactory;

public class ExceptionAwareThreadFactory
extends NexusThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAwareThreadFactory.class);

    public ExceptionAwareThreadFactory(String poolId, String threadGroupName) {
        super(poolId, threadGroupName);
    }

    public ExceptionAwareThreadFactory(String poolId, String threadGroupName, int threadPriority) {
        super(poolId, threadGroupName, threadPriority);
    }

    public ExceptionAwareThreadFactory(String poolId, String threadGroupName, int threadPriority, boolean daemonThread) {
        super(poolId, threadGroupName, threadPriority, daemonThread);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread tr = super.newThread(r);
        tr.setUncaughtExceptionHandler((t, e) -> log.error("Uncaught Exception occurred on thread: {}, Exception message: {}", (Object)t.getName(), (Object)e.getMessage()));
        return tr;
    }
}

