/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.testsupport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.junit.rules.ExternalResource;
import org.junit.runners.model.MultipleFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabaseManagerSupport;
import org.sonatype.nexus.orient.testsupport.internal.MemoryDatabaseManager;
import org.sonatype.nexus.orient.testsupport.internal.MinimalDatabaseServer;
import org.sonatype.nexus.orient.testsupport.internal.PersistentDatabaseManager;

public class DatabaseInstanceRule
extends ExternalResource {
    private static final Logger log;
    private final String name;
    private final boolean persistent;
    private MinimalDatabaseServer server;
    private DatabaseManagerSupport manager;
    private DatabaseInstance instance;

    static {
        try {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        catch (LinkageError linkageError) {}
        log = LoggerFactory.getLogger(DatabaseInstanceRule.class);
    }

    public static DatabaseInstanceRule inMemory(String name) {
        return new DatabaseInstanceRule(name, false);
    }

    public static DatabaseInstanceRule inFilesystem(String name) {
        return new DatabaseInstanceRule(name, true);
    }

    private DatabaseInstanceRule(String name, boolean persistent) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.persistent = persistent;
    }

    public MinimalDatabaseServer getServer() {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0);
        return this.server;
    }

    public DatabaseManager getManager() {
        Preconditions.checkState((this.manager != null ? 1 : 0) != 0);
        return this.manager;
    }

    public DatabaseInstance getInstance() {
        Preconditions.checkState((this.instance != null ? 1 : 0) != 0);
        return this.instance;
    }

    public Provider<DatabaseInstance> getInstanceProvider() {
        return this::getInstance;
    }

    protected void before() throws Throwable {
        log.info("Preparing database instance: {}", (Object)this.name);
        this.server = new MinimalDatabaseServer();
        this.server.start();
        this.manager = this.persistent ? new PersistentDatabaseManager() : new MemoryDatabaseManager();
        this.manager.start();
        this.instance = this.manager.instance(this.name);
        log.info("Database instance prepared");
    }

    protected void after() {
        log.info("Cleaning up database instance: {}", (Object)this.name);
        this.instance = null;
        ArrayList errors = Lists.newArrayListWithCapacity((int)2);
        if (this.manager != null) {
            try {
                this.manager.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop database manager", (Throwable)e);
                errors.add(e);
            }
            this.manager = null;
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop database server", (Throwable)e);
                errors.add(e);
            }
            this.server = null;
        }
        if (!errors.isEmpty()) {
            log.error("Failed to clean up database instance");
            throw new RuntimeException((Throwable)new MultipleFailureException((List)errors));
        }
        log.info("Database instance cleaned up");
    }
}

