/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.restore;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RestoreFile {
    private static final String TIMESTAMP_FORMAT = "%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS";
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(.*)-(\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2})(?:-(.*))?.bak");
    private final String timestamp;
    private final String databaseName;
    private final String version;

    private RestoreFile(String timestamp, String databaseName, @Nullable String version) {
        this.timestamp = (String)Preconditions.checkNotNull((Object)timestamp);
        this.databaseName = (String)Preconditions.checkNotNull((Object)databaseName);
        this.version = version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public static String formatFilename(String databaseName, LocalDateTime timestamp, String version) {
        return databaseName + "-" + String.format(TIMESTAMP_FORMAT, timestamp) + "-" + version.replace("-SNAPSHOT", "") + ".bak";
    }

    public static RestoreFile newInstance(Path path) {
        String basename;
        Matcher matcher;
        Path basepath;
        if (path != null && (basepath = path.getFileName()) != null && (matcher = FILENAME_PATTERN.matcher(basename = basepath.toString())).matches()) {
            String databaseName = matcher.group(1);
            String timestamp = matcher.group(2);
            String version = matcher.group(3);
            return new RestoreFile(timestamp, databaseName, version);
        }
        throw new IllegalArgumentException(path + " is not a valid restore file");
    }

    public String toString() {
        return "{databaseName=" + this.databaseName + ", timestamp=" + this.timestamp + ", version=" + this.version + "}";
    }
}

