/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.quorum;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class DatabaseQuorumStatus {
    private static final DatabaseQuorumStatus SINGLE = new DatabaseQuorumStatus((Collection<String>)ImmutableSet.of((Object)"local"), 1, null, (Collection<String>)ImmutableSet.of((Object)"local"));
    private final Set<String> members;
    private final Set<String> allConfiguredServers;
    private final int minimumForQuorum;
    private final String databaseName;

    public DatabaseQuorumStatus(Collection<String> members, int minimumForQuorum, String databaseName, Collection<String> allConfiguredServers) {
        this.members = Collections.unmodifiableSet(new HashSet<String>(members));
        this.minimumForQuorum = minimumForQuorum;
        this.databaseName = databaseName;
        this.allConfiguredServers = Collections.unmodifiableSet(new HashSet<String>(allConfiguredServers));
    }

    public static DatabaseQuorumStatus singleNode() {
        return SINGLE;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public int getMinimumForQuorum() {
        return this.minimumForQuorum;
    }

    public Set<String> getAllConfiguredServers() {
        return this.allConfiguredServers;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isQuorumPresent() {
        return this.getMembers().size() >= this.getMinimumForQuorum();
    }
}

