/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.status;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.Date;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.NotReadableException;
import org.sonatype.nexus.common.app.NotWritableException;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.internal.status.OrientStatusHealthCheckEntityAdapter;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientStatusHealthCheckStore
extends StateGuardLifecycleSupport {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientStatusHealthCheckEntityAdapter entityAdapter;
    private final NodeAccess nodeAccess;

    @Inject
    public OrientStatusHealthCheckStore(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, OrientStatusHealthCheckEntityAdapter entityAdapter, NodeAccess nodeAccess) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientStatusHealthCheckEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public void checkWritable(String errorMessage) {
        String nodeId = this.nodeAccess.getId();
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                OrientStatusHealthCheckEntityAdapter.NodeHealthCheck nhc = this.entityAdapter.read(db, nodeId);
                if (nhc == null) {
                    nhc = this.entityAdapter.newEntity();
                    nhc.nodeId = nodeId;
                    nhc.lastHealthCheck = new Date();
                    this.entityAdapter.addEntity(db, nhc);
                } else {
                    nhc.lastHealthCheck = new Date();
                    this.entityAdapter.editEntity(db, nhc);
                }
            });
        }
        catch (Exception e) {
            throw new NotWritableException(String.valueOf(errorMessage) + ". Database not writable on node: " + nodeId, (Throwable)e);
        }
    }

    @Guarded(by={"STARTED"})
    public void checkReadable(String errorMessage) {
        String nodeId = this.nodeAccess.getId();
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                OrientStatusHealthCheckEntityAdapter.NodeHealthCheck nodeHealthCheck = this.entityAdapter.read(db, nodeId);
            });
        }
        catch (Exception e) {
            throw new NotReadableException(String.valueOf(errorMessage) + ". Database not readable on node: " + nodeId, (Throwable)e);
        }
    }
}

