/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.freeze;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FreezeRequest;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.freeze.FreezeRequest;
import org.sonatype.nexus.orient.internal.status.OrientStatusHealthCheckStore;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientFreezeService
extends ComponentSupport
implements FreezeService {
    private static final String ANONYMOUS = "anonymous";
    private final DatabaseFreezeService databaseFreezeService;
    private final OrientStatusHealthCheckStore statusHealthCheckStore;
    private final SecurityHelper securityHelper;

    @Inject
    public OrientFreezeService(DatabaseFreezeService databaseFreezeService, OrientStatusHealthCheckStore statusHealthCheckStore, SecurityHelper securityHelper) {
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
        this.statusHealthCheckStore = (OrientStatusHealthCheckStore)((Object)Preconditions.checkNotNull((Object)((Object)statusHealthCheckStore)));
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    public void requestFreeze(String reason) {
        org.sonatype.nexus.orient.freeze.FreezeRequest request = this.databaseFreezeService.requestFreeze(FreezeRequest.InitiatorType.USER_INITIATED, this.currentUserId());
        Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"Freeze request rejected");
    }

    public void cancelFreeze() {
        Preconditions.checkState((boolean)this.databaseFreezeService.releaseUserInitiatedIfPresent(), (Object)"No such freeze request");
    }

    public void taskRequestFreeze(String token, String reason) {
        org.sonatype.nexus.orient.freeze.FreezeRequest request = this.databaseFreezeService.requestFreeze(FreezeRequest.InitiatorType.SYSTEM, token);
        Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"Freeze request rejected");
    }

    public void taskCancelFreeze(String token) {
        org.sonatype.nexus.orient.freeze.FreezeRequest originalRequest = this.databaseFreezeService.getState().stream().filter(r -> token.equals(r.getInitiatorId())).findFirst().orElseThrow(() -> new IllegalStateException("No such freeze request"));
        this.databaseFreezeService.releaseRequest(originalRequest);
    }

    public List<FreezeRequest> cancelAllFreezeRequests() {
        return Lists.transform(this.databaseFreezeService.releaseAllRequests(), this::adapt);
    }

    public boolean isFrozen() {
        return this.databaseFreezeService.isFrozen();
    }

    public List<FreezeRequest> currentFreezeRequests() {
        return Lists.transform(this.databaseFreezeService.getState(), this::adapt);
    }

    public void checkReadable(String errorMessage) {
        this.statusHealthCheckStore.checkReadable(errorMessage);
    }

    public void checkWritable(String errorMessage) {
        if (this.isFrozen()) {
            throw new FrozenException(errorMessage);
        }
        this.statusHealthCheckStore.checkWritable(errorMessage);
    }

    private String currentUserId() {
        return Optional.ofNullable(this.securityHelper.subject().getPrincipal()).map(Object::toString).orElse(ANONYMOUS);
    }

    private FreezeRequest adapt(org.sonatype.nexus.orient.freeze.FreezeRequest request) {
        String token;
        String userId;
        if (FreezeRequest.InitiatorType.USER_INITIATED == request.getInitiatorType()) {
            userId = request.getInitiatorId();
            token = null;
        } else {
            userId = null;
            token = request.getInitiatorId();
        }
        return new FreezeRequest(token, "", request.getTimestamp(), userId, null);
    }
}

