/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.action.QueryUtils;

public class UpdateEntityByPropertyAction<T extends Entity>
extends ComponentSupport {
    private final EntityAdapter<T> adapter;
    private final String query;

    public UpdateEntityByPropertyAction(EntityAdapter<T> adapter, String ... properties) {
        this.adapter = (EntityAdapter)((Object)Preconditions.checkNotNull(adapter));
        this.query = String.format("SELECT FROM %s WHERE %s", adapter.getTypeName(), QueryUtils.buildPredicate(properties));
    }

    public boolean execute(ODatabaseDocumentTx db, T entity, Object ... values) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(this.query)).execute(values);
        if (results.isEmpty()) {
            return false;
        }
        this.adapter.writeEntity((ODocument)results.get(0), entity);
        return true;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

