/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class SingletonActions<T extends Entity>
extends ComponentSupport {
    private final EntityAdapter<T> adapter;
    private final String key;

    public SingletonActions(EntityAdapter<T> adapter) {
        this.adapter = (EntityAdapter)((Object)Preconditions.checkNotNull(adapter));
        this.key = String.format("%s.SINGLETON", adapter.getTypeName());
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "key='" + this.key + '\'' + '}';
    }

    @Nullable
    public T get(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        ODictionary dictionary = db.getDictionary();
        ODocument document = (ODocument)dictionary.get(this.key);
        if (document != null) {
            return this.adapter.readEntity((OIdentifiable)document);
        }
        return null;
    }

    public boolean set(ODatabaseDocumentTx db, T entity) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull(entity);
        ODictionary dictionary = db.getDictionary();
        ODocument document = (ODocument)dictionary.get(this.key);
        if (document == null) {
            document = this.adapter.addEntity(db, entity);
            dictionary.put(this.key, (Object)document);
            return false;
        }
        this.adapter.writeEntity(document, entity);
        return true;
    }

    public boolean delete(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        ODictionary dictionary = db.getDictionary();
        ODocument document = (ODocument)dictionary.get(this.key);
        if (document != null) {
            db.delete((ORecord)document);
            dictionary.remove(this.key);
            return true;
        }
        return false;
    }

    public void replicate(ODocument document, EntityAdapter.EventKind eventKind) {
        ODictionary dictionary = document.getDatabase().getDictionary();
        switch (eventKind) {
            case CREATE: 
            case UPDATE: {
                dictionary.put(this.key, (Object)document);
                break;
            }
            case DELETE: {
                dictionary.remove(this.key);
                break;
            }
        }
    }
}

