/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

public class BrowseEntitiesByPropertyInSetAction<T extends Entity>
extends ComponentSupport {
    private final IterableEntityAdapter<T> adapter;
    private final String query;

    public BrowseEntitiesByPropertyInSetAction(IterableEntityAdapter<T> adapter, String property) {
        this.adapter = (IterableEntityAdapter)((Object)Preconditions.checkNotNull(adapter));
        this.query = String.format("SELECT * FROM %s WHERE %s IN [ %%s ]", adapter.getTypeName(), Preconditions.checkNotNull((Object)property));
    }

    public Iterable<T> execute(ODatabaseDocumentTx db, Collection<? extends Object> values) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkArgument((values != null && values.size() > 0 ? 1 : 0) != 0);
        String valueFields = values.stream().map(value -> "?").collect(Collectors.joining(","));
        String adjustedQuery = String.format(this.query, valueFields);
        Iterable results = (Iterable)db.command((OCommandRequest)new OSQLSynchQuery(adjustedQuery)).execute(values.toArray());
        return this.adapter.transform(results);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

