/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.ContinuationTokenHelper;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public abstract class OrientContinuationTokenHelper
implements ContinuationTokenHelper {
    private final EntityAdapter<?> entityAdapter;

    public OrientContinuationTokenHelper(EntityAdapter<?> entityAdapter) {
        this.entityAdapter = (EntityAdapter)((Object)Preconditions.checkNotNull(entityAdapter));
    }

    @Nullable
    public String getIdFromToken(String continuationToken) {
        try {
            return continuationToken != null && !continuationToken.isEmpty() ? this.entityAdapter.recordIdentity((EntityId)new DetachedEntityId(continuationToken)).toString() : null;
        }
        catch (IllegalArgumentException e) {
            throw new ContinuationTokenHelper.ContinuationTokenException(String.format("Invalid token '%s'", continuationToken), (Exception)e);
        }
    }

    public String getTokenFromId(Entity entity) {
        return EntityHelper.id((Entity)entity).getValue();
    }
}

