/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.Hex;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.orient.RecordIdObfuscatorSupport;

@Named(value="encrypted")
@Singleton
public class EncryptedRecordIdObfuscator
extends RecordIdObfuscatorSupport {
    private static final String CPREFIX = "${nexus.orient.encryptedRecordIdObfuscator";
    private static final String TRANSFORMATION = "DES/CBC/NoPadding";
    private final CryptoHelper crypto;
    private final AlgorithmParameterSpec paramSpec;
    private final SecretKey secretKey;

    @Inject
    public EncryptedRecordIdObfuscator(CryptoHelper crypto, @Named(value="${nexus.orient.encryptedRecordIdObfuscator.password:-changeme}") @Named(value="${nexus.orient.encryptedRecordIdObfuscator.password:-changeme}") String password, @Named(value="${nexus.orient.encryptedRecordIdObfuscator.salt:-changeme}") @Named(value="${nexus.orient.encryptedRecordIdObfuscator.salt:-changeme}") String salt, @Named(value="${nexus.orient.encryptedRecordIdObfuscator.iv:-0123456789ABCDEF}") @Named(value="${nexus.orient.encryptedRecordIdObfuscator.iv:-0123456789ABCDEF}") String iv) throws Exception {
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
        Preconditions.checkNotNull((Object)iv);
        this.paramSpec = new IvParameterSpec(Hex.decode((String)iv));
        SecretKeyFactory factory = crypto.createSecretKeyFactory("PBKDF2WithHmacSHA1");
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkNotNull((Object)salt);
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 1024, 64);
        SecretKey tmp = factory.generateSecret(spec);
        this.secretKey = new SecretKeySpec(tmp.getEncoded(), "DES");
    }

    @Override
    protected String doEncode(OClass type, ORID rid) throws Exception {
        Cipher cipher = this.crypto.createCipher(TRANSFORMATION);
        byte[] plain = ByteBuffer.allocate(16).put(rid.toStream()).array();
        cipher.init(1, (Key)this.secretKey, this.paramSpec);
        byte[] encrypted = cipher.doFinal(plain);
        return Hex.encode((byte[])encrypted);
    }

    @Override
    protected ORID doDecode(OClass type, String encoded) throws Exception {
        Cipher cipher = this.crypto.createCipher(TRANSFORMATION);
        byte[] encrypted = Hex.decode((String)encoded);
        cipher.init(2, (Key)this.secretKey, this.paramSpec);
        byte[] plain = cipher.doFinal(encrypted);
        return new ORecordId().fromStream(plain);
    }
}

