/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.DatabaseExternalizer;
import org.sonatype.nexus.orient.DatabaseManager;

public class DatabaseExternalizerImpl
extends ComponentSupport
implements DatabaseExternalizer {
    private final DatabaseManager databaseManager;
    private final String name;

    public DatabaseExternalizerImpl(DatabaseManager databaseManager, String name) {
        this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    private ODatabaseDocumentTx openDb() {
        return this.databaseManager.connect(this.name, false);
    }

    @Override
    public void backup(OutputStream output) throws IOException {
        Preconditions.checkNotNull((Object)output);
        this.log.debug("Backup database: {}", (Object)this.name);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = this.openDb();){
            Preconditions.checkState((boolean)db.exists(), (String)"Database does not exist: %s", (Object)this.name);
            this.log.debug("Starting backup");
            db.backup(output, null, null, (OCommandOutputListener)new LoggingCommandOutputListener("BACKUP"), this.databaseManager.getBackupCompressionLevel(), this.databaseManager.getBackupBufferSize());
            this.log.debug("Completed backup");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void restore(InputStream input, boolean overwrite) throws IOException {
        Preconditions.checkNotNull((Object)input);
        this.log.debug("Restoring database: {}", (Object)this.name);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ODatabaseDocumentTx db = this.openDb();){
            if (db.exists()) {
                Preconditions.checkState((boolean)overwrite, (String)"Database already exists: %s", (Object)this.name);
            } else {
                db.create();
            }
            this.log.debug("Starting restore");
            db.restore(input, null, null, (OCommandOutputListener)new LoggingCommandOutputListener("RESTORE"));
            this.log.debug("Completed restore");
            if (db.getStorage().isClosed()) {
                db.getStorage().open("admin", "admin", null);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void export(OutputStream output) throws IOException {
        this.export(output, Collections.emptySet());
    }

    @Override
    public void export(OutputStream output, Set<String> excludedClassNames) throws IOException {
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull(excludedClassNames);
        this.log.debug("Exporting database: {}", (Object)this.name);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ODatabaseDocumentTx db = this.openDb();){
            Preconditions.checkState((boolean)db.exists(), (String)"Database does not exist: %s", (Object)this.name);
            this.log.debug("Starting export");
            ODatabaseExport exporter = new ODatabaseExport((ODatabaseDocumentInternal)db, output, (OCommandOutputListener)new LoggingCommandOutputListener("EXPORT"));
            if (!excludedClassNames.isEmpty()) {
                this.log.debug("excluding : {}", excludedClassNames);
                exporter.setExcludeClasses((Set)ImmutableSortedSet.copyOf(Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER), excludedClassNames));
            }
            exporter.exportDatabase();
            this.log.debug("Completed export");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void import_(InputStream input, boolean overwrite) throws IOException {
        Preconditions.checkNotNull((Object)input);
        this.log.debug("Importing database: {}", (Object)this.name);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ODatabaseDocumentTx db = this.openDb();){
            if (db.exists()) {
                Preconditions.checkState((boolean)overwrite, (String)"Database already exists: %s", (Object)this.name);
            } else {
                db.create();
            }
            this.import_(db, input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void import_(ODatabaseDocumentTx db, InputStream input) throws IOException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)input);
        this.log.debug("Starting import");
        ODatabaseImport importer = new ODatabaseImport((ODatabaseDocumentInternal)db, input, (OCommandOutputListener)new LoggingCommandOutputListener("IMPORT"));
        importer.importDatabase();
        this.log.debug("Completed import");
    }

    public void maybeImportFromStandardLocation(ODatabaseDocumentTx db, File dir) throws Exception {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)dir);
        FilterInputStream input = null;
        File file = new File(dir, "export.json");
        if (file.exists()) {
            input = new BufferedInputStream(new FileInputStream(file), this.databaseManager.getImportBufferSize());
        } else {
            file = new File(dir, "export.json.gz");
            if (file.exists()) {
                input = new GZIPInputStream((InputStream)new FileInputStream(file), this.databaseManager.getImportBufferSize());
            }
        }
        if (input != null) {
            this.log.debug("Importing database: {} from: {}", (Object)this.name, (Object)file);
            try {
                this.import_(db, input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + '}';
    }

    private class LoggingCommandOutputListener
    implements OCommandOutputListener {
        private final String prefix;

        private LoggingCommandOutputListener(String prefix) {
            this.prefix = prefix;
        }

        public void onMessage(String text) {
            if (DatabaseExternalizerImpl.this.log.isDebugEnabled()) {
                DatabaseExternalizerImpl.this.log.debug("{}: {}", (Object)this.prefix, (Object)text.trim());
            }
        }
    }
}

