/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.orient.internal.util;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientGolangDataAccess {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);

    @Nullable
    private Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    public Iterable<Asset> findAssetsForModule(StorageTx tx, Repository repository, String moduleName) {
        Query query = Query.builder().where("name").like((Object)(String.valueOf(moduleName) + "/%")).build();
        return tx.findAssets(query, (Iterable)ImmutableList.of((Object)repository));
    }

    @TransactionalStoreBlob
    public Content maybeCreateAndSaveAsset(Repository repository, String assetPath, AssetKind assetKind, TempBlob tempBlob, Payload payload) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(tx, bucket = tx.findBucket(repository), assetPath);
        if (asset == null) {
            asset = tx.createAsset(bucket, repository.getFormat());
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.saveAsset(tx, asset, (InputStreamSupplier)tempBlob, payload);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    public Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @TransactionalStoreBlob
    public Content maybeCreateAndSaveComponent(Repository repository, GolangAttributes golangAttributes, String assetPath, TempBlob tempBlob, Payload payload, AssetKind assetKind) throws IOException {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        Component component = this.findComponent(tx, repository, golangAttributes.getModule(), golangAttributes.getVersion());
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, repository.getFormat()).name(golangAttributes.getModule())).version(golangAttributes.getVersion());
            tx.saveComponent(component);
        }
        if ((asset = this.findAsset(tx, bucket, assetPath)) == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.saveAsset(tx, asset, (InputStreamSupplier)tempBlob, payload);
    }

    public Payload getBlobAsPayload(StorageTx tx, Asset asset) {
        return new BlobPayload(tx.requireBlob(asset.requireBlobRef()), asset.requireContentType());
    }
}

