/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.orient.internal.proxy;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.util.GolangPathUtils;
import com.sonatype.nexus.repository.golang.orient.internal.util.OrientGolangDataAccess;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientGolangProxyFacetImpl
extends ProxyFacetSupport {
    private final OrientGolangDataAccess golangDataAccess;

    @Inject
    public OrientGolangProxyFacetImpl(OrientGolangDataAccess golangDataAccess) {
        this.golangDataAccess = (OrientGolangDataAccess)Preconditions.checkNotNull((Object)golangDataAccess);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = GolangPathUtils.matcherState(context);
        switch (assetKind) {
            case PACKAGE: 
            case INFO: 
            case MODULE: {
                return this.getAsset(GolangPathUtils.assetPath(matcherState));
            }
            case LIST: {
                return this.getAsset(GolangPathUtils.listPath(matcherState));
            }
            case LATEST: {
                return this.getAsset(GolangPathUtils.latestPath(matcherState));
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = GolangPathUtils.matcherState(context);
        switch (assetKind) {
            case PACKAGE: 
            case INFO: 
            case MODULE: {
                GolangAttributes golangAttributes = GolangPathUtils.getAttributesFromMatcherState(matcherState);
                return this.putComponent(golangAttributes, content, GolangPathUtils.assetPath(matcherState), assetKind);
            }
            case LIST: {
                return this.putAsset(content, GolangPathUtils.listPath(matcherState), assetKind);
            }
            case LATEST: {
                return this.putAsset(content, GolangPathUtils.latestPath(matcherState), assetKind);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case LIST: 
            case LATEST: {
                return this.cacheControllerHolder.getMetadataCacheController();
            }
        }
        return this.cacheControllerHolder.getContentCacheController();
    }

    @TransactionalTouchBlob
    protected Content getAsset(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.golangDataAccess.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        return this.golangDataAccess.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putAsset(Content content, String assetPath, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientGolangDataAccess.HASH_ALGORITHMS);){
            return this.golangDataAccess.maybeCreateAndSaveAsset(this.getRepository(), assetPath, assetKind, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putComponent(GolangAttributes golangAttributes, Content content, String assetPath, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientGolangDataAccess.HASH_ALGORITHMS);){
            return this.golangDataAccess.maybeCreateAndSaveComponent(this.getRepository(), golangAttributes, assetPath, tempBlob, (Payload)content, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent go asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }
}

