/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.orient.internal.hosted;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.golang.AssetKind;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangAttributes;
import com.sonatype.nexus.repository.golang.internal.metadata.GolangInfo;
import com.sonatype.nexus.repository.golang.internal.util.CompressedContentExtractor;
import com.sonatype.nexus.repository.golang.orient.internal.hosted.OrientGolangHostedFacet;
import com.sonatype.nexus.repository.golang.orient.internal.util.OrientGolangDataAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientGolangHostedFacetImpl
extends FacetSupport
implements OrientGolangHostedFacet {
    private static final String GO_MOD_FILENAME = "go.mod";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final OrientGolangDataAccess golangDataAccess;
    private final CompressedContentExtractor compressedContentExtractor;

    @Inject
    public OrientGolangHostedFacetImpl(OrientGolangDataAccess golangDataAccess, CompressedContentExtractor compressedContentExtractor) {
        this.golangDataAccess = (OrientGolangDataAccess)Preconditions.checkNotNull((Object)golangDataAccess);
        this.compressedContentExtractor = (CompressedContentExtractor)((Object)Preconditions.checkNotNull((Object)((Object)compressedContentExtractor)));
    }

    @Override
    @Nullable
    @Transactional
    public Content getInfo(String path, GolangAttributes golangAttributes) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)golangAttributes);
        String newPath = this.getZipAssetPathFromInfoPath(path);
        StreamPayload streamPayload = this.extractInfoFromZip(golangAttributes, newPath);
        if (streamPayload == null) {
            return null;
        }
        return new Content((Payload)streamPayload);
    }

    @Override
    @Transactional
    public Content getList(String module) {
        Preconditions.checkNotNull((Object)module);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Asset> assetsForModule = this.golangDataAccess.findAssetsForModule(tx, this.getRepository(), module);
        List collection = StreamSupport.stream(assetsForModule.spliterator(), false).filter(asset -> AssetKind.PACKAGE.name().equals(asset.formatAttributes().get("asset_kind"))).map(AbstractMetadataNode::name).map(name -> name.split("/@v/")[1]).map(name -> name.replaceAll(".zip", "")).collect(Collectors.toList());
        if (collection.isEmpty()) {
            return null;
        }
        String listOfVersions = String.join((CharSequence)"\n", collection);
        return new Content((Payload)new BytesPayload(listOfVersions.getBytes(StandardCharsets.UTF_8), "text/plain"));
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getPackage(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.doGet(path);
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getMod(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.doGet(path);
    }

    @Override
    public void upload(String path, GolangAttributes golangAttributes, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)golangAttributes);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)((Object)assetKind));
        if (assetKind != AssetKind.PACKAGE) {
            throw new IllegalArgumentException("Unsupported AssetKind");
        }
        this.storeContent(path, golangAttributes, payload, assetKind);
        this.extractAndSaveMod(path, golangAttributes);
    }

    private String getZipAssetPathFromInfoPath(String path) {
        return path.replaceAll("\\.info", "\\.zip");
    }

    private StreamPayload extractInfoFromZip(GolangAttributes goAttributes, String newPath) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.golangDataAccess.findAsset(tx, tx.findBucket(this.getRepository()), newPath);
        if (asset == null) {
            return null;
        }
        return new StreamPayload(() -> this.doGetInfo(asset, goAttributes), -1L, "application/json");
    }

    private InputStream doGetInfo(Asset asset, GolangAttributes goAttributes) {
        GolangInfo goInfo = new GolangInfo(goAttributes.getVersion(), asset.blobCreated().toString());
        try {
            String info = MAPPER.writeValueAsString((Object)goInfo);
            return new ByteArrayInputStream(info.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Unable to convert %s to json", goInfo), e);
        }
    }

    private Content doGet(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.golangDataAccess.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        return this.golangDataAccess.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private void storeContent(String path, GolangAttributes golangAttributes, Payload payload, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload.openInputStream(), OrientGolangDataAccess.HASH_ALGORITHMS);){
            this.golangDataAccess.maybeCreateAndSaveComponent(this.getRepository(), golangAttributes, path, tempBlob, payload, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractAndSaveMod(String path, GolangAttributes golangAttributes) {
        Payload content = this.getZip(path);
        if (content != null && this.goModExistsInZip(content, path)) {
            try {
                this.storeContent(path.replaceAll("\\.zip", "\\.mod"), golangAttributes, this.getModAsPayload(content, path), AssetKind.MODULE);
            }
            catch (IOException e) {
                this.log.warn("Unable to open content {}", (Object)path, (Object)e);
            }
        }
    }

    private Payload getModAsPayload(Payload content, String path) {
        return new StreamPayload(() -> this.doGetModAsStream(content, path), -1L, "text/plain");
    }

    private InputStream doGetModAsStream(Payload content, String path) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream contentStream = content.openInputStream();){
                InputStream inputStream = this.compressedContentExtractor.extractFile(contentStream, GO_MOD_FILENAME);
                Preconditions.checkNotNull((Object)inputStream, (Object)String.format("Unable to find file %s in %s", GO_MOD_FILENAME, path));
                return inputStream;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to open content %s", path), e);
        }
    }

    private boolean goModExistsInZip(Payload content, String path) {
        return this.compressedContentExtractor.fileExists(content, path, GO_MOD_FILENAME);
    }

    @TransactionalTouchBlob
    protected Payload getZip(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.golangDataAccess.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            this.log.warn("Unable to find {} for extraction", (Object)path);
            return null;
        }
        return this.golangDataAccess.getBlobAsPayload(tx, asset);
    }
}

