/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.golang.internal;

import com.sonatype.nexus.repository.golang.internal.util.GolangGroupListHelper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class GolangGroupListHandler
extends GroupHandler {
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) {
        List<Map.Entry<Repository, Response>> successfulResponses = this.getAllSuccessfulResponses(context, dispatched);
        if (successfulResponses.isEmpty()) {
            return HttpResponses.notFound();
        }
        List<List<String>> listOfVersions = this.deserialize(context, successfulResponses);
        List<String> versions = GolangGroupListHelper.combineVersions(listOfVersions);
        if (versions.isEmpty()) {
            return this.asEmptyResponse();
        }
        Set<String> result = GolangGroupListHelper.mergeListOfVersions(versions);
        return this.asResponse(result);
    }

    private List<List<String>> deserialize(Context context, List<Map.Entry<Repository, Response>> responses) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (Map.Entry<Repository, Response> entry : responses) {
            Response response = entry.getValue();
            Payload payload = response.getPayload();
            try {
                List<String> versions = GolangGroupListHelper.deserialize(payload);
                result.add(versions);
            }
            catch (Exception exception) {
                Exception logException = this.log.isDebugEnabled() ? exception : null;
                this.log.warn("Could not deserialize '@v/list' metadata. Request path {} for the group repository {} for the member {}", new Object[]{context.getRequest().getPath(), context.getRepository().getName(), entry.getKey().getName(), logException});
            }
        }
        return result;
    }

    private List<Map.Entry<Repository, Response>> getAllSuccessfulResponses(Context context, GroupHandler.DispatchedRepositories dispatched) {
        ArrayList<Map.Entry<Repository, Response>> result = new ArrayList<Map.Entry<Repository, Response>>();
        List members = ((GroupFacet)context.getRepository().facet(GroupFacet.class)).members();
        for (Repository member : members) {
            try {
                Response response = super.getFirst(context, Collections.singletonList(member), dispatched);
                if (!response.getStatus().isSuccessful()) continue;
                result.add(new AbstractMap.SimpleEntry<Repository, Response>(member, response));
            }
            catch (Exception exception) {
                String requestPath = context.getRequest().getPath();
                String repositoryName = member.getName();
                String groupRepoName = context.getRepository().getName();
                Exception logException = this.log.isDebugEnabled() ? exception : null;
                this.log.warn("Could not get '@v/list' metadata {} from the group repository {} for the member {}", new Object[]{requestPath, groupRepoName, repositoryName, logException});
            }
        }
        return result;
    }

    private Response asResponse(Collection<String> versions) {
        String result = String.join((CharSequence)"\n", versions);
        StringPayload payload = new StringPayload(result, "text/plain");
        return HttpResponses.ok((Payload)payload);
    }

    private Response asEmptyResponse() {
        StringPayload payload = new StringPayload("", "text/plain");
        return HttpResponses.ok((Payload)payload);
    }
}

