/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;

public class OrientQuartzSchema {
    private static final String SCHED_NAME = "SCHED_NAME";
    private static final String CALENDAR_NAME = "CALENDAR_NAME";
    private static final String TRIGGER_NAME = "TRIGGER_NAME";
    private static final String TRIGGER_GROUP = "TRIGGER_GROUP";
    private static final String INSTANCE_NAME = "INSTANCE_NAME";
    private static final String JOB_NAME = "JOB_NAME";
    private static final String JOB_GROUP = "JOB_GROUP";

    private OrientQuartzSchema() {
    }

    public static void register(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        OSchemaProxy schema = db.getMetadata().getSchema();
        OrientQuartzSchema.calendars((OSchema)schema);
        OrientQuartzSchema.cronTriggers((OSchema)schema);
        OrientQuartzSchema.firedTriggers((OSchema)schema);
        OrientQuartzSchema.pausedTriggerGrps((OSchema)schema);
        OrientQuartzSchema.schedulerState((OSchema)schema);
        OrientQuartzSchema.locks((OSchema)schema);
        OrientQuartzSchema.jobDetails((OSchema)schema);
        OrientQuartzSchema.simpleTriggers((OSchema)schema);
        OrientQuartzSchema.simpropTriggers((OSchema)schema);
        OrientQuartzSchema.blobTriggers((OSchema)schema);
        OrientQuartzSchema.triggers((OSchema)schema);
    }

    private static void calendars(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_CALENDARS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, CALENDAR_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "CALENDAR", OType.BINARY, true);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_CALENDARS", SCHED_NAME, CALENDAR_NAME);
    }

    private static void cronTriggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_CRON_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "CRON_EXPRESSION", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "TIME_ZONE_ID", OType.STRING, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_CRON_TRIGGERS", SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
    }

    private static void firedTriggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_FIRED_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "ENTRY_ID", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, INSTANCE_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "FIRED_TIME", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "SCHED_TIME", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "PRIORITY", OType.INTEGER, true);
        OrientQuartzSchema.maybeCreateProperty(type, "STATE", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_NAME, OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_GROUP, OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "IS_NONCONCURRENT", OType.BOOLEAN, false);
        OrientQuartzSchema.maybeCreateProperty(type, "REQUESTS_RECOVERY", OType.BOOLEAN, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_FIRED_TRIGGERS", SCHED_NAME, "ENTRY_ID");
    }

    private static void pausedTriggerGrps(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_PAUSED_TRIGGER_GRPS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_PAUSED_TRIGGER_GRPS", SCHED_NAME, TRIGGER_GROUP);
    }

    private static void schedulerState(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_SCHEDULER_STATE");
        OrientQuartzSchema.maybeCreateProperty(type, INSTANCE_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "LAST_CHECKIN_TIME", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "CHECKIN_INTERVAL", OType.LONG, true);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_SCHEDULER_STATE", SCHED_NAME, INSTANCE_NAME);
    }

    private static void locks(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_LOCKS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "LOCK_NAME", OType.STRING, true);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_LOCKS", SCHED_NAME, "LOCK_NAME");
    }

    private static void jobDetails(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_JOB_DETAILS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "DESCRIPTION", OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "JOB_CLASS_NAME", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "IS_DURABLE", OType.BOOLEAN, true);
        OrientQuartzSchema.maybeCreateProperty(type, "IS_NONCONCURRENT", OType.BOOLEAN, true);
        OrientQuartzSchema.maybeCreateProperty(type, "IS_UPDATE_DATA", OType.BOOLEAN, true);
        OrientQuartzSchema.maybeCreateProperty(type, "REQUESTS_RECOVERY", OType.BOOLEAN, true);
        OrientQuartzSchema.maybeCreateProperty(type, "JOB_DATA", OType.BINARY, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_JOB_DETAILS", SCHED_NAME, JOB_NAME, JOB_GROUP);
    }

    private static void simpleTriggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_SIMPLE_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "REPEAT_COUNT", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "REPEAT_INTERVAL", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "TIMES_TRIGGERED", OType.LONG, true);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_SIMPLE_TRIGGERS", SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
    }

    private static void simpropTriggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_SIMPROP_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "STR_PROP_1", OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "STR_PROP_2", OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "STR_PROP_3", OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "INT_PROP_1", OType.INTEGER, false);
        OrientQuartzSchema.maybeCreateProperty(type, "INT_PROP_2", OType.INTEGER, false);
        OrientQuartzSchema.maybeCreateProperty(type, "LONG_PROP_1", OType.LONG, false);
        OrientQuartzSchema.maybeCreateProperty(type, "LONG_PROP_2", OType.LONG, false);
        OrientQuartzSchema.maybeCreateProperty(type, "DEC_PROP_1", OType.DECIMAL, false);
        OrientQuartzSchema.maybeCreateProperty(type, "DEC_PROP_2", OType.DECIMAL, false);
        OrientQuartzSchema.maybeCreateProperty(type, "BOOL_PROP_1", OType.BOOLEAN, false);
        OrientQuartzSchema.maybeCreateProperty(type, "BOOL_PROP_2", OType.BOOLEAN, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_SIMPROP_TRIGGERS", SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
    }

    private static void blobTriggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_BLOB_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "BLOB_DATA", OType.BINARY, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_BLOB_TRIGGERS", SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
    }

    private static void triggers(OSchema schema) {
        OClass type = OrientQuartzSchema.maybeCreateClass(schema, "QRTZ_TRIGGERS");
        OrientQuartzSchema.maybeCreateProperty(type, SCHED_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, TRIGGER_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_NAME, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, JOB_GROUP, OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "DESCRIPTION", OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "NEXT_FIRE_TIME", OType.LONG, false);
        OrientQuartzSchema.maybeCreateProperty(type, "PREV_FIRE_TIME", OType.LONG, false);
        OrientQuartzSchema.maybeCreateProperty(type, "PRIORITY", OType.INTEGER, false);
        OrientQuartzSchema.maybeCreateProperty(type, "TRIGGER_STATE", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "TRIGGER_TYPE", OType.STRING, true);
        OrientQuartzSchema.maybeCreateProperty(type, "START_TIME", OType.LONG, true);
        OrientQuartzSchema.maybeCreateProperty(type, "END_TIME", OType.LONG, false);
        OrientQuartzSchema.maybeCreateProperty(type, CALENDAR_NAME, OType.STRING, false);
        OrientQuartzSchema.maybeCreateProperty(type, "MISFIRE_INSTR", OType.SHORT, false);
        OrientQuartzSchema.maybeCreateProperty(type, "JOB_DATA", OType.BINARY, false);
        OrientQuartzSchema.maybeCreateIndex(type, "PK_QRTZ_TRIGGERS", SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
    }

    private static OClass maybeCreateClass(OSchema schema, String className) {
        OClass clazz = schema.getClass(className);
        if (clazz == null) {
            clazz = schema.createClass(className);
        }
        return clazz;
    }

    private static OProperty maybeCreateProperty(OClass clazz, String name, OType type, boolean notNull) {
        OProperty property = clazz.getProperty(name);
        if (property == null) {
            property = clazz.createProperty(name, type);
            if (notNull) {
                property = property.setMandatory(true).setNotNull(true);
            }
        }
        return property;
    }

    private static OIndex<?> maybeCreateIndex(OClass clazz, String name, String ... props) {
        OIndex index = clazz.getClassIndex(name);
        if (index == null) {
            index = clazz.createIndex(name, OClass.INDEX_TYPE.UNIQUE, props);
        }
        return index;
    }
}

