/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.orient;

import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.quartz.utils.ConnectionProvider;

public class OrientConnectionProvider
implements ConnectionProvider {
    private String connectionString = "plocal:./quartz";
    private String user = "admin";
    private String password = "admin";
    private boolean usePool = true;
    private int poolMin = 3;
    private int poolMax = 30;
    private Properties info;

    public Connection getConnection() throws SQLException {
        return new OrientJdbcConnection("jdbc:orient:" + this.connectionString, this.info);
    }

    public void shutdown() throws SQLException {
        this.info = null;
    }

    public void initialize() throws SQLException {
        this.info = new Properties();
        this.info.put("user", this.user);
        this.info.put("password", this.password);
        this.info.put("db.usePool", Boolean.toString(this.usePool));
        this.info.put("db.pool.min", Integer.toString(this.poolMin));
        this.info.put("db.pool.max", Integer.toString(this.poolMax));
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String path) {
        this.connectionString = path;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public int getPoolMin() {
        return this.poolMin;
    }

    public void setPoolMin(int poolMin) {
        this.poolMin = poolMin;
    }

    public int getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMax(int poolMax) {
        this.poolMax = poolMax;
    }
}

