/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.scheduling.TaskConfiguration;

public class QuartzTaskUtils {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzTaskUtils.class);

    private QuartzTaskUtils() {
    }

    @Nullable
    public static Trigger getJobTrigger(JobExecutionContext context) {
        try {
            JobKey jobKey = context.getJobDetail().getKey();
            return context.getScheduler().getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
        }
        catch (SchedulerException e) {
            LOG.debug("Unable to get job trigger for context: {}", (Object)context, (Object)e);
            return null;
        }
    }

    public static Trigger getCurrentTrigger(JobExecutionContext context) {
        Trigger jobTrigger = QuartzTaskUtils.getJobTrigger(context);
        return jobTrigger != null ? jobTrigger : context.getTrigger();
    }

    public static TaskConfiguration configurationOf(JobDetail jobDetail) {
        Preconditions.checkNotNull((Object)jobDetail);
        return QuartzTaskUtils.configurationOf(jobDetail.getJobDataMap());
    }

    public static TaskConfiguration configurationOf(JobDataMap jobDataMap) {
        Preconditions.checkNotNull((Object)jobDataMap);
        TaskConfiguration config = new TaskConfiguration();
        for (Map.Entry entry : jobDataMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            config.setString((String)entry.getKey(), (String)entry.getValue());
        }
        return config;
    }

    public static void updateJobData(JobDetail jobDetail, TaskConfiguration taskConfiguration) {
        QuartzTaskUtils.updateJobData(jobDetail.getJobDataMap(), taskConfiguration);
    }

    public static void updateJobData(JobDataMap jobDataMap, TaskConfiguration taskConfiguration) {
        taskConfiguration.asMap().forEach((key, value) -> {
            if ("-1".equals(value)) {
                jobDataMap.remove(key);
            } else if (!value.equals(jobDataMap.get(key))) {
                jobDataMap.put(key, value);
            }
        });
    }
}

