/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskState;
import org.sonatype.nexus.scheduling.CurrentState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.events.TaskDeletedEvent;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QuartzTaskInfo
extends ComponentSupport
implements TaskInfo {
    static final String TASK_INFO_KEY = QuartzTaskInfo.class.getName();
    private final EventManager eventManager;
    private final QuartzSchedulerSPI scheduler;
    private final JobKey jobKey;
    private volatile TaskState state;
    private volatile QuartzTaskState taskState;
    private volatile QuartzTaskFuture taskFuture;
    private volatile boolean removed;
    private Object lastResult;
    private final Map<String, Object> context = new ConcurrentHashMap<String, Object>();

    public QuartzTaskInfo(EventManager eventManager, QuartzSchedulerSPI scheduler, JobKey jobKey, QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.scheduler = (QuartzSchedulerSPI)((Object)Preconditions.checkNotNull((Object)((Object)scheduler)));
        this.jobKey = (JobKey)Preconditions.checkNotNull((Object)jobKey);
        this.removed = false;
        this.setNexusTaskState(taskFuture != null ? TaskState.RUNNING : TaskState.WAITING, taskState, taskFuture);
    }

    public synchronized boolean isRemovedOrDone() {
        return this.removed || this.state.isDone();
    }

    public synchronized void setNexusTaskState(TaskState newState, QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        Preconditions.checkNotNull((Object)newState);
        Preconditions.checkNotNull((Object)taskState);
        Preconditions.checkState((!newState.isRunning() || taskFuture != null ? 1 : 0) != 0, (Object)"Running task must have future");
        TaskConfiguration config = taskState.getConfiguration();
        if (this.state == null) {
            this.log.info("Task {} : state={}", (Object)config.getTaskLogName(), (Object)newState);
        } else if (this.state != newState) {
            String newStateName = newState.name();
            if (newState.isWaiting() && taskState.getLastRunState() != null) {
                newStateName = String.valueOf(newStateName) + " (" + taskState.getLastRunState().getEndState().name() + ")";
            }
            if (config.isLogTaskState()) {
                if (this.log.isDebugEnabled()) {
                    this.log.info("Task {} : {} state change {} -> {}", new Object[]{this.jobKey, config.getTaskLogName(), this.state, newStateName});
                } else {
                    this.log.info("Task {} state change {} -> {}", new Object[]{config.getTaskLogName(), this.state, newStateName});
                }
            }
        } else if (config.isLogTaskState()) {
            this.log.debug("Task {} : {} : state={} nextRun={}", new Object[]{this.jobKey.getName(), config.getTaskLogName(), newState, taskState.getNextExecutionTime()});
        }
        this.state = newState;
        this.taskState = taskState;
        this.taskFuture = taskFuture;
        if (!this.removed && newState.isDone()) {
            this.scheduler.removeTask(this.jobKey);
            this.removed = true;
            this.log.debug("Task {} : {} is done and removed", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
        }
    }

    public synchronized void setNexusTaskStateIfWaiting(QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        if (this.state.isWaiting()) {
            this.setNexusTaskState(this.state, taskState, taskFuture);
        }
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    @Nullable
    public QuartzTaskFuture getTaskFuture() {
        return this.taskFuture;
    }

    public String getId() {
        return this.getConfiguration().getId();
    }

    public String getName() {
        return this.getConfiguration().getName();
    }

    public String getTypeId() {
        return this.getConfiguration().getTypeId();
    }

    public String getMessage() {
        return this.getConfiguration().getMessage();
    }

    public synchronized TaskConfiguration getConfiguration() {
        return this.taskState.getConfiguration();
    }

    public synchronized Schedule getSchedule() {
        return this.taskState.getSchedule();
    }

    public synchronized CurrentState getCurrentState() {
        if (this.taskState.getSchedule() instanceof Manual) {
            return new CurrentStateImpl(this.state, null, this.taskFuture);
        }
        return new CurrentStateImpl(this.state, this.taskState.getNextExecutionTime(), this.taskFuture);
    }

    @Nullable
    public Object getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(Object result) {
        this.lastResult = result;
    }

    public synchronized boolean remove() {
        TaskConfiguration config = this.taskState.getConfiguration();
        if (this.isRemovedOrDone()) {
            this.log.debug("Task {} : {} already removed", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
            return true;
        }
        if (this.taskFuture != null && !this.taskFuture.cancel(false)) {
            this.log.debug("Task {} : {} is running as is not cancelable", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
            return false;
        }
        if (!config.hasLastRunState()) {
            config.setLastRunState(TaskState.CANCELED, new Date(), 0L);
        }
        this.removed = true;
        boolean result = this.scheduler.removeTask(this.jobKey);
        if (result) {
            this.log.info("Task {} removed", (Object)config.getTaskLogName());
            this.eventManager.post((Object)new TaskDeletedEvent((TaskInfo)this));
        } else {
            this.log.warn("Task {} vanished", (Object)config.getTaskLogName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo runNow(String triggerSource) throws TaskRemovedException {
        QuartzTaskInfo quartzTaskInfo = this;
        synchronized (quartzTaskInfo) {
            Preconditions.checkState((!this.state.isRunning() ? 1 : 0) != 0, (String)"Task %s already running", (Object)this.taskState.getConfiguration().getTaskLogName());
            if (!this.getConfiguration().isEnabled()) {
                this.log.warn("Task {} is disabled and will not be run", (Object)this.taskState.getConfiguration().getTaskLogName());
                return this;
            }
            if (this.isRemovedOrDone()) {
                throw new TaskRemovedException("Task removed: " + this.jobKey);
            }
        }
        try {
            this.log.info("Task {} runNow", (Object)this.taskState.getConfiguration().getTaskLogName());
            this.scheduler.runNow(triggerSource, this.jobKey, this, this.taskState);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getTriggerSource() {
        QuartzTaskFuture currentTaskFuture = this.taskFuture;
        return currentTaskFuture != null ? currentTaskFuture.getTriggerSource() : null;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "jobKey=" + this.jobKey + ", state=" + this.state + ", taskState=" + this.taskState + ", taskFuture=" + this.taskFuture + ", removed=" + this.removed + '}';
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    private static class CurrentStateImpl
    implements CurrentState {
        private final TaskState state;
        private final Date nextRun;
        private final QuartzTaskFuture future;

        public CurrentStateImpl(TaskState state, Date nextRun, QuartzTaskFuture taskFuture) {
            this.state = state;
            this.nextRun = nextRun;
            this.future = taskFuture;
        }

        public TaskState getState() {
            return this.state;
        }

        @Nullable
        public Date getNextRun() {
            return this.nextRun;
        }

        @Nullable
        public Date getRunStarted() {
            return this.state.isRunning() ? this.future.getStartedAt() : null;
        }

        @Nullable
        public TaskState getRunState() {
            return this.state.isRunning() ? this.future.getRunState() : null;
        }

        @Nullable
        public QuartzTaskFuture getFuture() {
            return this.future;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "state=" + this.state + ", nextRun=" + this.nextRun + ", future=" + this.future + '}';
        }
    }
}

