/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobStore;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LastShutdownTimeService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.thread.DatabaseStatusDelayedExecutor;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class OrientQuartzSchedulerSPI
extends QuartzSchedulerSPI {
    @Inject
    public OrientQuartzSchedulerSPI(EventManager eventManager, NodeAccess nodeAccess, Provider<JobStore> jobStoreProvider, Provider<Scheduler> schedulerProvider, LastShutdownTimeService lastShutdownTimeService, DatabaseStatusDelayedExecutor delayedExecutor, @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") boolean recoverInterruptedJobs) {
        super(eventManager, nodeAccess, jobStoreProvider, schedulerProvider, lastShutdownTimeService, delayedExecutor, recoverInterruptedJobs);
    }

    public void remoteJobCreated(JobDetail jobDetail) {
        this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
        this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
    }

    public void remoteJobUpdated(JobDetail jobDetail) throws SchedulerException {
        this.updateJobListener(jobDetail);
        this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
        this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
    }

    public void remoteJobDeleted(JobDetail jobDetail) throws SchedulerException {
        this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
        this.quartzScheduler.notifySchedulerListenersJobDeleted(jobDetail.getKey());
        this.removeJobListener(jobDetail.getKey());
    }

    public void remoteTriggerCreated(Trigger trigger) throws SchedulerException {
        if (!OrientQuartzSchedulerSPI.isRunNow(trigger)) {
            this.attachJobListener(((JobStore)this.jobStoreProvider.get()).retrieveJob(trigger.getJobKey()), trigger);
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(OrientQuartzSchedulerSPI.getNextFireMillis(trigger));
            this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
        } else if (this.isLimitedToThisNode(trigger)) {
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
        }
    }

    public void remoteTriggerUpdated(Trigger trigger) throws SchedulerException {
        if (!OrientQuartzSchedulerSPI.isRunNow(trigger)) {
            this.updateJobListener(trigger);
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(OrientQuartzSchedulerSPI.getNextFireMillis(trigger));
            this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
            this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
        }
    }

    public void remoteTriggerDeleted(Trigger trigger) throws SchedulerException {
        if (!OrientQuartzSchedulerSPI.isRunNow(trigger)) {
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
            this.removeJobListener(trigger.getJobKey());
        }
    }
}

