/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.Map;
import org.sonatype.nexus.quartz.internal.orient.InstanceCreator;
import org.sonatype.nexus.quartz.internal.orient.Marshaller;

public class JacksonMarshaller
implements Marshaller {
    private static final TypeReference<Map<String, Object>> MAP_STRING_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper objectMapper;
    private final InstanceCreator instanceCreator;

    public JacksonMarshaller(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.instanceCreator = new InstanceCreator();
    }

    @Override
    public OType getType() {
        return OType.EMBEDDEDMAP;
    }

    @Override
    public Object marshall(Object value) throws Exception {
        return this.objectMapper.convertValue(value, MAP_STRING_OBJECT_TYPE);
    }

    @Override
    public <T> T unmarshall(Object marshalled, Class<T> type) throws Exception {
        Preconditions.checkNotNull((Object)marshalled);
        Preconditions.checkState((boolean)(marshalled instanceof Map), (String)"Marshalled data must be a Map; found: %s", marshalled.getClass());
        T value = this.instanceCreator.newInstance(type);
        ObjectReader reader = this.objectMapper.readerForUpdating(value);
        TokenBuffer buff = new TokenBuffer((ObjectCodec)this.objectMapper, false);
        this.objectMapper.writeValue((JsonGenerator)buff, marshalled);
        reader.readValue(buff.asParser());
        return type.cast(value);
    }
}

