/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.datastore;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.utils.Key;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.quartz.internal.datastore.QuartzDAO;
import org.sonatype.nexus.quartz.internal.datastore.QuartzTaskStateData;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskUtils;
import org.sonatype.nexus.scheduling.CurrentState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.spi.TaskResultState;
import org.sonatype.nexus.scheduling.spi.TaskResultStateStore;
import org.sonatype.nexus.transaction.Transactional;

@Named
@Singleton
public class TaskResultStateStoreImpl
extends ConfigStoreSupport<QuartzDAO>
implements TaskResultStateStore {
    protected Scheduler scheduler;

    @Inject
    public TaskResultStateStoreImpl(DataSessionSupplier sessionSupplier, Scheduler scheduler) {
        super(sessionSupplier);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
    }

    public Optional<TaskResultState> getState(TaskInfo taskInfo) {
        return Optional.ofNullable(taskInfo).map(QuartzTaskInfo.class::cast).map(QuartzTaskInfo::getJobKey).map(Key::getName).flatMap(this::getQuartzState).map(Collections::singletonList).map(jobStates -> this.aggregate(taskInfo, (List<QuartzTaskStateData>)jobStates));
    }

    public void updateJobDataMap(TaskInfo taskInfo) {
        String jobName = ((QuartzTaskInfo)taskInfo).getJobKey().getName();
        JobDataMap jobDataMap = new JobDataMap();
        QuartzTaskUtils.updateJobData(jobDataMap, taskInfo.getConfiguration());
        if (!taskInfo.getConfiguration().getBoolean(".runWhenFrozen", false)) {
            this.doUpdateJobDataMap(jobName, jobDataMap);
        }
    }

    @Transactional
    protected List<QuartzTaskStateData> getQuartzStates() {
        return ((QuartzDAO)this.dao()).getStates();
    }

    @Transactional
    protected Optional<QuartzTaskStateData> getQuartzState(String taskId) {
        return ((QuartzDAO)this.dao()).getState(taskId);
    }

    @Transactional
    protected void doUpdateJobDataMap(String jobName, JobDataMap jobDataMap) {
        QuartzTaskStateData quartzTaskStateData = new QuartzTaskStateData();
        quartzTaskStateData.setJobName(jobName);
        quartzTaskStateData.setJobData(jobDataMap);
        ((QuartzDAO)this.dao()).updateJobDataMap(quartzTaskStateData);
    }

    private TaskResultState aggregate(TaskInfo taskInfo, List<QuartzTaskStateData> jobStates) {
        TaskConfiguration taskConfiguration = jobStates.stream().map(QuartzTaskStateData::getJobData).filter(Objects::nonNull).map(QuartzTaskUtils::configurationOf).filter(Objects::nonNull).findAny().orElse(null);
        if (taskConfiguration == null) {
            return null;
        }
        Date nextFireTime = null;
        JobKey jobKey = ((QuartzTaskInfo)taskInfo).getJobKey();
        try {
            nextFireTime = Optional.ofNullable(this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()))).map(Trigger::getNextFireTime).orElseGet(() -> ((CurrentState)taskInfo.getCurrentState()).getNextRun());
        }
        catch (SchedulerException e) {
            this.log.debug("An error occurred finding the next fire time for {}", (Object)taskConfiguration.getId(), (Object)e);
            nextFireTime = taskInfo.getCurrentState().getNextRun();
        }
        boolean running = jobStates.stream().map(QuartzTaskStateData::getState).anyMatch("EXECUTING"::equals);
        return new TaskResultState(taskConfiguration.getId(), running ? TaskState.RUNNING : TaskState.WAITING, nextFireTime, taskConfiguration.getLastRunState(), taskConfiguration.getProgress());
    }
}

