/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.datastore;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.listeners.SchedulerListenerSupport;
import org.quartz.spi.JobStore;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LastShutdownTimeService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.datastore.CancelJobEvent;
import org.sonatype.nexus.quartz.internal.datastore.JobCreatedEvent;
import org.sonatype.nexus.quartz.internal.datastore.JobDeletedEvent;
import org.sonatype.nexus.quartz.internal.datastore.JobEventSupport;
import org.sonatype.nexus.quartz.internal.datastore.JobUpdatedEvent;
import org.sonatype.nexus.quartz.internal.datastore.TriggerCreatedEvent;
import org.sonatype.nexus.quartz.internal.datastore.TriggerDeletedEvent;
import org.sonatype.nexus.quartz.internal.datastore.TriggerEventSupport;
import org.sonatype.nexus.quartz.internal.datastore.TriggerUpdatedEvent;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskJobListener;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.thread.DatabaseStatusDelayedExecutor;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class DatastoreQuartzSchedulerSPI
extends QuartzSchedulerSPI
implements EventAware {
    private final Object mutex = new Object();

    @Inject
    public DatastoreQuartzSchedulerSPI(EventManager eventManager, NodeAccess nodeAccess, Provider<JobStore> jobStoreProvider, Provider<Scheduler> schedulerProvider, LastShutdownTimeService lastShutdownTimeService, DatabaseStatusDelayedExecutor delayedExecutor, @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") boolean recoverInterruptedJobs) {
        super(eventManager, nodeAccess, jobStoreProvider, schedulerProvider, lastShutdownTimeService, delayedExecutor, recoverInterruptedJobs);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)new SchedulerListenerSupport(){

            public void jobScheduled(Trigger trigger) {
                if (!EventHelper.isReplicating()) {
                    DatastoreQuartzSchedulerSPI.this.eventManager.post((Object)new TriggerCreatedEvent(trigger.getKey()));
                }
            }

            public void jobUnscheduled(TriggerKey triggerKey) {
                if (!EventHelper.isReplicating()) {
                    DatastoreQuartzSchedulerSPI.this.eventManager.post((Object)new TriggerDeletedEvent(triggerKey));
                }
            }
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean cancel(String id, boolean mayInterruptIfRunning) {
        boolean locallyCancelled = super.cancel(id, mayInterruptIfRunning);
        if (locallyCancelled) {
            return true;
        }
        if (!EventHelper.isReplicating()) {
            this.eventManager.post((Object)new CancelJobEvent(id, mayInterruptIfRunning));
        }
        return false;
    }

    private Optional<QuartzTaskJobListener> attachJobListener(JobKey jobKey) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            return Optional.of(this.attachJobListener(jobDetail, trigger));
        }
        catch (SchedulerException e) {
            this.log.warn("Unable to attach listener for task '{}' cause {}", new Object[]{jobKey, e.getMessage(), this.log.isDebugEnabled() ? e : null});
            return Optional.empty();
        }
    }

    @Override
    protected synchronized QuartzTaskJobListener attachJobListener(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        JobListener jobListener = this.scheduler.getListenerManager().getJobListener(QuartzTaskJobListener.listenerName(jobDetail.getKey()));
        if (jobListener != null) {
            this.updateJobListener(jobDetail);
            return (QuartzTaskJobListener)jobListener;
        }
        return super.attachJobListener(jobDetail, trigger);
    }

    @Override
    protected Map<JobKey, QuartzTaskInfo> allTasks() throws SchedulerException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            return this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"nexus")).stream().map(this::getOrCreateQuartzTaskInfo).filter(Objects::nonNull).collect(Collectors.toMap(QuartzTaskInfo::getJobKey, Function.identity()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    private QuartzTaskInfo getOrCreateQuartzTaskInfo(JobKey jobKey) {
        QuartzTaskJobListener listener = this.getExistingListener(jobKey);
        if (listener != null) {
            return listener.getTaskInfo();
        }
        return this.attachJobListener(jobKey).map(QuartzTaskJobListener::getTaskInfo).orElse(null);
    }

    @Nullable
    private QuartzTaskJobListener getExistingListener(JobKey jobKey) {
        try {
            return (QuartzTaskJobListener)this.scheduler.getListenerManager().getJobListener(QuartzTaskJobListener.listenerName(jobKey));
        }
        catch (SchedulerException e) {
            this.log.debug("An error occurred retrieving the listener for jobKey {}", (Object)jobKey, (Object)e);
            return null;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    protected QuartzTaskInfo createNewJob(TaskConfiguration config, Schedule schedule) throws SchedulerException {
        QuartzTaskInfo taskInfo = super.createNewJob(config, schedule);
        if (!EventHelper.isReplicating()) {
            this.eventManager.post((Object)new JobCreatedEvent(taskInfo.getJobKey()));
        }
        return taskInfo;
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean removeTask(JobKey jobKey) {
        boolean removed = super.removeTask(jobKey);
        if (removed && !EventHelper.isReplicating()) {
            this.eventManager.post((Object)new JobDeletedEvent(jobKey));
        }
        return removed;
    }

    @Override
    @Guarded(by={"STARTED"})
    protected QuartzTaskInfo updateJob(QuartzTaskInfo old, TaskConfiguration config, Schedule schedule) throws SchedulerException {
        QuartzTaskInfo taskInfo = super.updateJob(old, config, schedule);
        if (!EventHelper.isReplicating()) {
            this.eventManager.post((Object)new JobUpdatedEvent(taskInfo.getJobKey()));
        }
        return taskInfo;
    }

    @Subscribe
    public void on(CancelJobEvent event) {
        if (EventHelper.isReplicating()) {
            this.log.debug("Received remote request to cancel {}", (Object)event.getId());
            this.cancel(event.getId(), event.isMayInterruptIfRunning());
        }
    }

    @Subscribe
    public void on(JobCreatedEvent event) {
        this.handle(event, (JobDetail jobDetail) -> {
            this.attachJobListener(jobDetail.getKey());
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
        });
    }

    @Subscribe
    public void on(JobDeletedEvent event) {
        this.handle(event, (JobDetail jobDetail) -> {
            this.removeJobListener(jobDetail.getKey());
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobDeleted(jobDetail.getKey());
        });
    }

    @Subscribe
    public void on(JobUpdatedEvent event) {
        this.handle(event, (JobDetail jobDetail) -> {
            this.updateJobListener((JobDetail)jobDetail);
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(JobEventSupport event, Consumer<JobDetail> handler) {
        if (EventHelper.isReplicating()) {
            this.log.debug("Received {} for {} from node {}", new Object[]{((Object)((Object)event)).getClass(), event.getJobKey(), event.getRemoteNodeId()});
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                    JobDetail jobDetail = this.scheduler.getJobDetail(event.getJobKey());
                    if (jobDetail == null) {
                        this.log.debug("Missing job for {}", (Object)event.getJobKey());
                        return;
                    }
                    Object object = this.mutex;
                    synchronized (object) {
                        handler.accept(jobDetail);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SchedulerException e) {
                this.log.warn("Error handling {} for {} cause {}", new Object[]{((Object)((Object)event)).getClass(), event.getJobKey(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            }
        }
    }

    @Subscribe
    public void on(TriggerCreatedEvent event) {
        this.handle(event, (Trigger trigger) -> {
            if (!DatastoreQuartzSchedulerSPI.isRunNow(trigger)) {
                this.attachJobListener(((JobStore)this.jobStoreProvider.get()).retrieveJob(trigger.getJobKey()), (Trigger)trigger);
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(DatastoreQuartzSchedulerSPI.getNextFireMillis(trigger));
                this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
            } else if (this.isLimitedToThisNode((Trigger)trigger)) {
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
                this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
            }
        });
    }

    @Subscribe
    public void remoteTriggerUpdated(TriggerUpdatedEvent event) throws SchedulerException {
        this.handle(event, (Trigger trigger) -> {
            if (!DatastoreQuartzSchedulerSPI.isRunNow(trigger)) {
                this.updateJobListener((Trigger)trigger);
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(DatastoreQuartzSchedulerSPI.getNextFireMillis(trigger));
                this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
                this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
            }
        });
    }

    @Subscribe
    public void remoteTriggerDeleted(TriggerDeletedEvent event) throws SchedulerException {
        this.handle(event, (Trigger trigger) -> {
            if (!DatastoreQuartzSchedulerSPI.isRunNow(trigger)) {
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
                this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
                this.removeJobListener(trigger.getJobKey());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(TriggerEventSupport event, Consumer<Trigger> handler) {
        if (EventHelper.isReplicating()) {
            this.log.debug("Received {} for {} from node {}", new Object[]{((Object)((Object)event)).getClass(), event.getTriggerKey(), event.getRemoteNodeId()});
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                    Trigger trigger = this.scheduler.getTrigger(event.getTriggerKey());
                    if (trigger == null) {
                        this.log.debug("Missing trigger {}", (Object)event.getTriggerKey());
                        return;
                    }
                    Object object = this.mutex;
                    synchronized (object) {
                        handler.accept(trigger);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SchedulerException e) {
                this.log.warn("Error handling {} for {} cause {}", new Object[]{((Object)((Object)event)).getClass(), event.getTriggerKey(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            }
        }
    }

    @FunctionalInterface
    private static interface Consumer<E> {
        public void accept(E var1) throws SchedulerException;
    }
}

