/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.JobPersistenceException;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.spi.JobStore;
import org.quartz.utils.Key;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LastShutdownTimeService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.quartz.internal.QuartzScheduleFactory;
import org.sonatype.nexus.quartz.internal.QuartzTriggerConverter;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskJob;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskJobListener;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskState;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskUtils;
import org.sonatype.nexus.scheduling.CurrentState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;
import org.sonatype.nexus.thread.DatabaseStatusDelayedExecutor;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public abstract class QuartzSchedulerSPI
extends StateGuardLifecycleSupport
implements SchedulerSPI {
    public static final String MISSING_TRIGGER_RECOVERY = ".missingTriggerRecovery";
    protected static final String GROUP_NAME = "nexus";
    private static final Set<String> INHERITED_CONFIG_KEYS = ImmutableSet.of((Object)"limitnode");
    protected final EventManager eventManager;
    private final NodeAccess nodeAccess;
    protected final Provider<JobStore> jobStoreProvider;
    protected final ScheduleFactory scheduleFactory;
    private final Provider<Scheduler> schedulerProvider;
    protected final QuartzTriggerConverter triggerConverter;
    private final LastShutdownTimeService lastShutdownTimeService;
    private final DatabaseStatusDelayedExecutor delayedExecutor;
    private final boolean recoverInterruptedJobs;
    protected Scheduler scheduler;
    protected QuartzScheduler quartzScheduler;
    private boolean active;

    @Inject
    public QuartzSchedulerSPI(EventManager eventManager, NodeAccess nodeAccess, Provider<JobStore> jobStoreProvider, Provider<Scheduler> schedulerProvider, LastShutdownTimeService lastShutdownTimeService, DatabaseStatusDelayedExecutor delayedExecutor, @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") boolean recoverInterruptedJobs) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.jobStoreProvider = (Provider)Preconditions.checkNotNull(jobStoreProvider);
        this.schedulerProvider = (Provider)Preconditions.checkNotNull(schedulerProvider);
        this.lastShutdownTimeService = (LastShutdownTimeService)Preconditions.checkNotNull((Object)lastShutdownTimeService);
        this.recoverInterruptedJobs = recoverInterruptedJobs;
        this.delayedExecutor = (DatabaseStatusDelayedExecutor)Preconditions.checkNotNull((Object)delayedExecutor);
        this.scheduleFactory = new QuartzScheduleFactory();
        this.triggerConverter = new QuartzTriggerConverter(this.scheduleFactory);
        this.active = true;
    }

    public QuartzTriggerConverter triggerConverter() {
        return this.triggerConverter;
    }

    @VisibleForTesting
    Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void doStart() throws Exception {
        this.scheduler = (Scheduler)this.schedulerProvider.get();
        try {
            Field schedField = this.scheduler.getClass().getDeclaredField("sched");
            schedField.setAccessible(true);
            this.quartzScheduler = (QuartzScheduler)schedField.get(this.scheduler);
        }
        catch (Exception | LinkageError e) {
            this.log.error("Cannot find QuartzScheduler", e);
            throw e;
        }
        this.reattachListeners();
    }

    private void reattachListeners() {
        Optional lastShutdownTime = this.lastShutdownTimeService.estimateLastShutdownTime();
        this.forEachNexusJob((trigger, jobDetail) -> {
            try {
                this.updateLastRunStateInfo((JobDetail)jobDetail, lastShutdownTime);
            }
            catch (SchedulerException e) {
                this.log.error("Error updating last run state for {}", (Object)jobDetail.getKey(), (Object)e);
            }
        });
        this.forEachNexusJob((trigger, jobDetail) -> {
            try {
                this.stubJobListener((JobDetail)jobDetail);
            }
            catch (SchedulerException e) {
                this.log.error("Error attaching job listener to {}", (Object)jobDetail.getKey(), (Object)e);
            }
        });
        this.delayedExecutor.execute(() -> {
            this.forEachNexusJob((trigger, jobDetail) -> {
                try {
                    this.updateJobListener((Trigger)trigger);
                }
                catch (SchedulerException e) {
                    this.log.error("Error attaching job listener to {}", (Object)jobDetail.getKey(), (Object)e);
                }
            });
            if (this.recoverInterruptedJobs) {
                this.forEachNexusJob(this::recoverJob);
            }
        });
    }

    private void forEachNexusJob(BiConsumer<Trigger, JobDetail> consumer) {
        try {
            for (Map.Entry<Trigger, JobDetail> entry : this.getNexusJobs().entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
        catch (SchedulerException e) {
            this.log.error("Error getting jobs to process", (Throwable)e);
        }
    }

    @VisibleForTesting
    void recoverJob(Trigger trigger, JobDetail jobDetail) {
        if (QuartzSchedulerSPI.shouldRecoverJob(trigger, jobDetail).booleanValue()) {
            try {
                Trigger newTrigger = TriggerBuilder.newTrigger().usingJobData(trigger.getJobDataMap()).withDescription("Recovery of " + trigger.getDescription()).forJob(jobDetail).startNow().build();
                this.log.info("Recovering job {}", (Object)newTrigger.getJobKey());
                this.scheduler.scheduleJob(newTrigger);
            }
            catch (SchedulerException e) {
                this.log.error("Failed to recover job {}", (Object)trigger.getJobKey(), (Object)e);
            }
        }
    }

    private static Boolean shouldRecoverJob(Trigger trigger, JobDetail jobDetail) {
        if (!(jobDetail.requestsRecovery() && QuartzSchedulerSPI.isInterruptedJob(jobDetail) || QuartzSchedulerSPI.isRunNow(trigger))) {
            return false;
        }
        return true;
    }

    protected void updateLastRunStateInfo(JobDetail jobDetail, Optional<Date> nexusLastRunTime) throws SchedulerException {
        Optional<Date> latestFireWrapper = this.scheduler.getTriggersOfJob(jobDetail.getKey()).stream().filter(Objects::nonNull).map(Trigger::getPreviousFireTime).filter(Objects::nonNull).max(Date::compareTo);
        if (latestFireWrapper.isPresent()) {
            TaskConfiguration taskConfig = QuartzTaskUtils.configurationOf(jobDetail);
            Date latestFire = latestFireWrapper.get();
            if (!taskConfig.hasLastRunState() || taskConfig.getLastRunState().getRunStarted().before(latestFire)) {
                long estimatedDuration = Math.max(nexusLastRunTime.orElse(latestFire).getTime() - latestFire.getTime(), 0L);
                taskConfig.setLastRunState(TaskState.INTERRUPTED, latestFire, estimatedDuration);
                this.log.warn("Updating lastRunState to interrupted for jobKey {} taskConfig: {}", (Object)jobDetail.getKey(), (Object)taskConfig);
                try {
                    QuartzTaskUtils.updateJobData(jobDetail, taskConfig);
                    this.scheduler.addJob(jobDetail, true, true);
                }
                catch (RuntimeException e) {
                    this.log.warn("Problem updating lastRunState to interrupted for jobKey {}", (Object)jobDetail.getKey(), (Object)e);
                }
            }
        }
    }

    protected void doStop() throws Exception {
        this.scheduler = null;
    }

    public void pause() {
        try {
            this.setActive(false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void resume() {
        try {
            this.setActive(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void setActive(boolean started) throws SchedulerException {
        this.active = started;
        if (this.isStarted()) {
            this.applyActive();
        }
    }

    private void applyActive() throws SchedulerException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            if (!this.active && !this.scheduler.isInStandbyMode()) {
                this.scheduler.standby();
                this.log.info("Scheduler put into stand-by mode");
            } else if (this.active && this.scheduler.isInStandbyMode()) {
                this.scheduler.start();
                this.log.info("Scheduler put into ready mode");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Trigger scheduleJobWithManualTrigger(JobKey jobKey, JobDetail jobDetail, TriggerKey triggerKey) throws SchedulerException {
        this.log.error("Missing trigger for key: {}", (Object)jobKey);
        Trigger trigger = this.triggerConverter.convert((Schedule)new Manual()).usingJobData(jobDetail.getJobDataMap()).usingJobData(MISSING_TRIGGER_RECOVERY, jobKey.getName()).withIdentity(triggerKey).withDescription(jobDetail.getDescription()).forJob(jobDetail).build();
        this.log.info("Rescheduling job '{}' with manual trigger", (Object)jobDetail.getDescription());
        this.scheduler.scheduleJob(trigger);
        return trigger;
    }

    protected QuartzTaskJobListener attachJobListener(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.log.debug("Initializing task-state: jobDetail={}, trigger={}", (Object)jobDetail, (Object)trigger);
        Date now = new Date();
        TaskConfiguration taskConfiguration = QuartzTaskUtils.configurationOf(jobDetail);
        Schedule schedule = this.triggerConverter.convert(trigger);
        QuartzTaskState taskState = new QuartzTaskState(taskConfiguration, schedule, trigger.getFireTimeAfter(now));
        QuartzTaskFuture future = null;
        if (this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.BLOCKED) {
            future = new QuartzTaskFuture(this, jobDetail.getKey(), taskConfiguration.getTaskLogName(), trigger.getStartTime(), schedule, null);
        } else if (schedule instanceof Now) {
            future = new QuartzTaskFuture(this, jobDetail.getKey(), taskConfiguration.getTaskLogName(), now, schedule, null);
        }
        QuartzTaskJobListener listener = new QuartzTaskJobListener(QuartzTaskJobListener.listenerName(jobDetail.getKey()), this.eventManager, this, new QuartzTaskInfo(this.eventManager, this, jobDetail.getKey(), taskState, future));
        this.scheduler.getListenerManager().addJobListener((JobListener)listener, (Matcher)KeyMatcher.keyEquals((Key)jobDetail.getKey()));
        return listener;
    }

    private QuartzTaskJobListener stubJobListener(JobDetail jobDetail) throws SchedulerException {
        this.log.debug("Stubbing task-state: jobDetail={}", (Object)jobDetail);
        TaskConfiguration taskConfiguration = QuartzTaskUtils.configurationOf(jobDetail);
        Manual schedule = this.scheduleFactory.manual();
        QuartzTaskState taskState = new QuartzTaskState(taskConfiguration, (Schedule)schedule, null);
        QuartzTaskJobListener listener = new QuartzTaskJobListener(QuartzTaskJobListener.listenerName(jobDetail.getKey()), this.eventManager, this, new QuartzTaskInfo(this.eventManager, this, jobDetail.getKey(), taskState, null));
        this.scheduler.getListenerManager().addJobListener((JobListener)listener, (Matcher)KeyMatcher.keyEquals((Key)jobDetail.getKey()));
        return listener;
    }

    @Nullable
    private QuartzTaskJobListener findJobListener(JobKey jobKey) throws SchedulerException {
        String name = QuartzTaskJobListener.listenerName(jobKey);
        return (QuartzTaskJobListener)this.scheduler.getListenerManager().getJobListener(name);
    }

    protected void updateJobListener(JobDetail jobDetail) throws SchedulerException {
        QuartzTaskJobListener toBeUpdated = this.findJobListener(jobDetail.getKey());
        if (toBeUpdated != null) {
            QuartzTaskInfo taskInfo = toBeUpdated.getTaskInfo();
            taskInfo.setNexusTaskStateIfWaiting(new QuartzTaskState(taskInfo.getConfiguration().apply(QuartzTaskUtils.configurationOf(jobDetail)), taskInfo.getSchedule(), taskInfo.getCurrentState().getNextRun()), taskInfo.getTaskFuture());
        }
    }

    protected void updateJobListener(Trigger trigger) throws SchedulerException {
        QuartzTaskJobListener toBeUpdated = this.findJobListener(trigger.getJobKey());
        if (toBeUpdated != null) {
            QuartzTaskInfo taskInfo = toBeUpdated.getTaskInfo();
            taskInfo.setNexusTaskStateIfWaiting(new QuartzTaskState(taskInfo.getConfiguration(), this.triggerConverter.convert(trigger), trigger.getFireTimeAfter(new Date())), taskInfo.getTaskFuture());
        }
    }

    protected void removeJobListener(JobKey jobKey) throws SchedulerException {
        String name = QuartzTaskJobListener.listenerName(jobKey);
        QuartzTaskJobListener toBeRemoved = (QuartzTaskJobListener)this.scheduler.getListenerManager().getJobListener(name);
        if (toBeRemoved != null) {
            QuartzTaskFuture future = toBeRemoved.getTaskInfo().getTaskFuture();
            if (future != null && !future.isDone()) {
                future.doCancel();
            }
            this.scheduler.getListenerManager().removeJobListener(name);
        }
    }

    @Guarded(by={"STARTED"})
    public ScheduleFactory scheduleFactory() {
        return this.scheduleFactory;
    }

    @Guarded(by={"STARTED"})
    public String renderStatusMessage() {
        SchedulerMetaData metaData;
        StringBuilder buff = new StringBuilder();
        try {
            metaData = this.scheduler.getMetaData();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        if (metaData.isShutdown()) {
            buff.append("Shutdown");
        } else {
            if (metaData.getRunningSince() != null) {
                buff.append("Started");
            } else {
                buff.append("Stopped");
            }
            if (metaData.isInStandbyMode()) {
                buff.append("; Stand-by");
            }
        }
        return buff.toString();
    }

    @Guarded(by={"STARTED"})
    public String renderDetailMessage() {
        try {
            return this.scheduler.getMetaData().getSummary();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public TaskInfo getTaskById(String id) {
        try {
            QuartzTaskInfo task = this.findTaskById(id);
            if (task != null && !task.isRemovedOrDone()) {
                return task;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Guarded(by={"STARTED"})
    public List<TaskInfo> listsTasks() {
        try {
            return this.allTasks().values().stream().filter(task -> !task.isRemovedOrDone()).collect(Collectors.toList());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Guarded(by={"STARTED"})
    public List<String> getMissingTriggerDescriptions() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)GROUP_NAME));
                ArrayList<String> missingJobDescriptions = new ArrayList<String>();
                for (JobKey jobKey : jobKeys) {
                    Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    if (!trigger.getJobDataMap().containsKey((Object)MISSING_TRIGGER_RECOVERY)) continue;
                    missingJobDescriptions.add(trigger.getDescription());
                }
                return missingJobDescriptions;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Guarded(by={"STARTED"})
    public TaskInfo scheduleTask(TaskConfiguration config, Schedule schedule) {
        Preconditions.checkState((!EventHelper.isReplicating() ? 1 : 0) != 0, (Object)"Replication in progress");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                QuartzTaskInfo old = this.findTaskById(config.getId());
                if (old != null) {
                    return this.updateJob(old, config, schedule);
                }
                return this.createNewJob(config, schedule);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected QuartzTaskInfo createNewJob(TaskConfiguration config, Schedule schedule) throws SchedulerException {
        JobKey jobKey = JobKey.jobKey((String)UUID.randomUUID().toString(), (String)GROUP_NAME);
        JobDetail jobDetail = this.buildJob(config, jobKey);
        Trigger trigger = this.buildTrigger(schedule, jobDetail);
        this.log.debug("Task {} : {} scheduled with key: {} and schedule: {}", new Object[]{config.getId(), config.getTaskLogName(), jobKey.getName(), schedule});
        QuartzTaskJobListener listener = this.attachJobListener(jobDetail, trigger);
        this.scheduler.scheduleJob(jobDetail, trigger);
        if (!config.isEnabled()) {
            this.scheduler.pauseJob(jobKey);
        }
        return listener.getTaskInfo();
    }

    protected QuartzTaskInfo updateJob(QuartzTaskInfo old, TaskConfiguration config, Schedule schedule) throws SchedulerException {
        Preconditions.checkState((!(old.getSchedule() instanceof Now) ? 1 : 0) != 0, (Object)"Run 'now' task cannot be rescheduled");
        Preconditions.checkState((!old.isRemovedOrDone() ? 1 : 0) != 0, (Object)"Done task cannot be rescheduled");
        QuartzTaskFuture future = old.getTaskFuture();
        if (future != null) {
            Preconditions.checkState((!(schedule instanceof Now) ? 1 : 0) != 0, (Object)"Running task cannot be rescheduled with 'now'");
        }
        this.log.debug("Task {} : {} rescheduled {} -> {} ", new Object[]{old.getJobKey().getName(), old.getConfiguration().getTaskLogName(), old.getSchedule(), schedule});
        JobDetail jobDetail = this.buildJob(config, old.getJobKey());
        Trigger trigger = this.buildTrigger(schedule, jobDetail);
        this.scheduler.addJob(jobDetail, true, true);
        this.scheduler.rescheduleJob(trigger.getKey(), trigger);
        JobDataMap jobData = trigger.getJobDataMap();
        String type = jobData.getString("schedule.type");
        if ("cron".equals(type)) {
            this.verifyCron(jobData);
        }
        old.setNexusTaskStateIfWaiting(new QuartzTaskState(config, schedule, trigger.getFireTimeAfter(new Date())), future);
        if (!config.isEnabled()) {
            this.scheduler.pauseJob(old.getJobKey());
        } else {
            this.scheduler.resumeJob(old.getJobKey());
        }
        return old;
    }

    private void verifyCron(JobDataMap jobData) throws SchedulerException {
        Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
        String cronExpression = jobData.getString("schedule.cronExpression");
        try {
            this.scheduleFactory.cron(startAt, cronExpression);
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    private JobDetail buildJob(TaskConfiguration config, JobKey jobKey) {
        return JobBuilder.newJob(QuartzTaskJob.class).withIdentity(jobKey).withDescription(config.getName()).requestRecovery(config.isRecoverable()).usingJobData(new JobDataMap(config.asMap())).build();
    }

    private Trigger buildTrigger(Schedule schedule, JobDetail jobDetail) {
        return this.ensureStartsInTheFuture(this.triggerConverter.convert(schedule).withIdentity(jobDetail.getKey().getName(), jobDetail.getKey().getGroup()).withDescription(jobDetail.getDescription()).usingJobData(new JobDataMap(Maps.filterKeys((Map)jobDetail.getJobDataMap(), INHERITED_CONFIG_KEYS::contains))).build());
    }

    @Guarded(by={"STARTED"})
    public int getRunningTaskCount() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                return this.scheduler.getCurrentlyExecutingJobs().size();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Guarded(by={"STARTED"})
    public int getExecutedTaskCount() {
        return this.quartzScheduler.numJobsExecuted();
    }

    private Trigger ensureStartsInTheFuture(Trigger trigger) {
        Date fireTimeAfter;
        Date now = new Date();
        if (trigger.getStartTime().before(now) && (fireTimeAfter = trigger.getFireTimeAfter(now)) != null) {
            return trigger.getTriggerBuilder().startAt(fireTimeAfter).build();
        }
        return trigger;
    }

    protected Map<JobKey, QuartzTaskInfo> allTasks() throws SchedulerException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            HashMap<JobKey, QuartzTaskInfo> result = new HashMap<JobKey, QuartzTaskInfo>();
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)GROUP_NAME));
            for (JobKey jobKey : jobKeys) {
                QuartzTaskJobListener listener = this.findJobListener(jobKey);
                if (listener != null) {
                    result.put(jobKey, listener.getTaskInfo());
                    continue;
                }
                this.log.debug("Job missing listener; omitting from results: {}", (Object)jobKey);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<Trigger, JobDetail> getNexusJobs() throws SchedulerException {
        HashMap<Trigger, JobDetail> nexusJobs = new HashMap<Trigger, JobDetail>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)GROUP_NAME));
            for (JobKey jobKey : jobKeys) {
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                if (jobDetail == null) {
                    this.log.error("Missing job-detail for key: {}", (Object)jobKey);
                    continue;
                }
                TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
                Trigger trigger = this.scheduler.getTrigger(triggerKey);
                if (trigger == null) {
                    trigger = this.scheduleJobWithManualTrigger(jobKey, jobDetail, triggerKey);
                }
                nexusJobs.put(trigger, jobDetail);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return nexusJobs;
    }

    @Nullable
    @VisibleForTesting
    protected QuartzTaskInfo findTaskById(String id) throws SchedulerException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            return this.allTasks().values().stream().filter(task -> task.getId().equals(id)).findFirst().orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public boolean cancelJob(JobKey jobKey) {
        Preconditions.checkNotNull((Object)jobKey);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                return this.scheduler.interrupt(jobKey);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnableToInterruptJobException e) {
            this.log.debug("Unable to interrupt job with key: {}", (Object)jobKey, (Object)e);
            return false;
        }
    }

    @Guarded(by={"STARTED"})
    public void runNow(String triggerSource, JobKey jobKey, QuartzTaskInfo taskInfo, QuartzTaskState taskState) throws TaskRemovedException, SchedulerException {
        Preconditions.checkState((boolean)this.active, (Object)"Cannot run tasks while scheduler is paused");
        TaskConfiguration config = taskState.getConfiguration();
        if (!this.isLimitedToAnotherNode(config)) {
            taskInfo.setNexusTaskState(TaskState.RUNNING, taskState, new QuartzTaskFuture(this, jobKey, config.getTaskLogName(), new Date(), (Schedule)this.scheduleFactory().now(), triggerSource));
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                JobDataMap triggerDetail = this.triggerConverter.convert((Schedule)this.scheduleFactory().now()).build().getJobDataMap();
                triggerDetail.putAll(Maps.filterKeys((Map)config.asMap(), INHERITED_CONFIG_KEYS::contains));
                this.scheduler.triggerJob(jobKey, triggerDetail);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JobPersistenceException e) {
            throw new TaskRemovedException(jobKey.getName(), (Throwable)e);
        }
    }

    @Guarded(by={"STARTED"})
    public boolean removeTask(JobKey jobKey) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                boolean result = false;
                List triggers = this.scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    boolean bl = result = this.scheduler.unscheduleJob(trigger.getKey()) || result;
                }
                this.removeJobListener(jobKey);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Guarded(by={"STARTED"})
    public boolean cancel(String id, boolean mayInterruptIfRunning) {
        return Optional.ofNullable(id).map(this::getTaskById).map(TaskInfo::getCurrentState).map(CurrentState::getFuture).map(f -> f.cancel(mayInterruptIfRunning)).orElse(false);
    }

    @Nullable
    public TaskInfo getTaskByTypeId(String typeId) {
        return this.getTaskByTypeId(typeId, Collections.emptyMap());
    }

    @Nullable
    public TaskInfo getTaskByTypeId(String typeId, Map<String, String> config) {
        Preconditions.checkNotNull((Object)typeId);
        Preconditions.checkNotNull(config);
        return this.listsTasks().stream().filter(t -> typeId.equals(t.getTypeId())).filter(this.matchConfig(config)).findFirst().orElse(null);
    }

    public boolean findAndSubmit(String typeId) {
        return this.findAndSubmit(typeId, Collections.emptyMap());
    }

    public boolean findAndSubmit(String typeId, Map<String, String> config) {
        Preconditions.checkNotNull((Object)typeId);
        Preconditions.checkNotNull(config);
        TaskInfo taskInfo = this.getTaskByTypeId(typeId, config);
        if (taskInfo == null) {
            return false;
        }
        try {
            if (!taskInfo.getCurrentState().getState().isRunning()) {
                taskInfo.runNow();
            }
        }
        catch (TaskRemovedException e) {
            this.log.error("Unable to submit task: {}", (Object)taskInfo, (Object)e);
        }
        return true;
    }

    private Predicate<TaskInfo> matchConfig(Map<String, String> config) {
        return t -> {
            TaskConfiguration tc = t.getConfiguration();
            return config.entrySet().stream().filter(e -> e.getKey() != null).filter(e -> e.getValue() != null).allMatch(e -> ((String)e.getValue()).equals(tc.getString((String)e.getKey())));
        };
    }

    public boolean isLimitedToAnotherNode(TaskConfiguration config) {
        if (this.nodeAccess.isClustered() && config.containsKey("limitnode")) {
            String limitedNodeId = config.getString("limitnode");
            Preconditions.checkState((!Strings2.isBlank((String)limitedNodeId) ? 1 : 0) != 0, (String)"Task '%s' is not configured for HA", (Object)config.getName());
            Preconditions.checkState((boolean)this.nodeAccess.getMemberIds().contains(limitedNodeId), (String)"Task '%s' uses node %s which is not a member of this cluster", (Object)config.getName(), (Object)limitedNodeId);
            return !this.nodeAccess.getId().equals(limitedNodeId);
        }
        return false;
    }

    protected boolean isLimitedToThisNode(Trigger trigger) {
        return this.nodeAccess.getId().equals(trigger.getJobDataMap().getString("limitnode"));
    }

    protected static boolean isRunNow(Trigger trigger) {
        return "now".equals(trigger.getJobDataMap().getString("schedule.type"));
    }

    private static boolean isInterruptedJob(JobDetail jobDetail) {
        return TaskState.INTERRUPTED.name().equals(jobDetail.getJobDataMap().getString("lastRunState.endState"));
    }

    protected static long getNextFireMillis(Trigger trigger) {
        Date nextFireTime = trigger.getNextFireTime();
        return nextFireTime != null ? nextFireTime.getTime() : 0L;
    }
}

