/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.quartz.Scheduler;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.SchedulerRepository;
import org.quartz.spi.JobFactory;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.BindAsLifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.quartz.internal.QuartzThreadPool;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class QuartzSchedulerProvider
extends LifecycleSupport
implements Provider<Scheduler> {
    private static final String SCHEDULER_NAME = "nexus";
    private final NodeAccess nodeAccess;
    private final Provider<JobStore> jobStore;
    private final JobFactory jobFactory;
    private final int threadPoolSize;
    private final int threadPriority;
    private volatile Scheduler scheduler;

    @Inject
    public QuartzSchedulerProvider(NodeAccess nodeAccess, Provider<JobStore> jobStore, JobFactory jobFactory, @Named(value="${nexus.quartz.poolSize:-20}") @Named(value="${nexus.quartz.poolSize:-20}") int threadPoolSize, @Named(value="${nexus.quartz.taskThreadPriority:-5}") @Named(value="${nexus.quartz.taskThreadPriority:-5}") int threadPriority) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.jobStore = (Provider)Preconditions.checkNotNull(jobStore);
        this.jobFactory = (JobFactory)Preconditions.checkNotNull((Object)jobFactory);
        Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (String)"Invalid thread-pool size: %s", (int)threadPoolSize);
        this.threadPoolSize = threadPoolSize;
        this.threadPriority = threadPriority;
        this.log.info("Thread-pool size: {}, Thread-pool priority: {}", (Object)threadPoolSize, (Object)threadPriority);
    }

    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        SchedulerRepository.getInstance().remove(SCHEDULER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler get() {
        Scheduler localRef = this.scheduler;
        if (localRef == null) {
            QuartzSchedulerProvider quartzSchedulerProvider = this;
            synchronized (quartzSchedulerProvider) {
                localRef = this.scheduler;
                if (localRef == null) {
                    this.scheduler = localRef = this.createScheduler();
                }
            }
        }
        return localRef;
    }

    private Scheduler createScheduler() {
        try {
            DefaultThreadExecutor threadExecutor = new DefaultThreadExecutor(){

                public void execute(Thread thread) {
                    thread.setContextClassLoader(QuartzSchedulerProvider.class.getClassLoader());
                    super.execute(thread);
                }
            };
            DirectSchedulerFactory.getInstance().createScheduler(SCHEDULER_NAME, this.nodeAccess.getId(), (ThreadPool)new QuartzThreadPool(this.threadPoolSize, this.threadPriority), (ThreadExecutor)threadExecutor, (JobStore)this.jobStore.get(), null, null, 0, -1L, -1L, true, null, 1, 0L);
            Scheduler s = DirectSchedulerFactory.getInstance().getScheduler(SCHEDULER_NAME);
            s.setJobFactory(this.jobFactory);
            this.log.info("Quartz Scheduler v{}", (Object)s.getMetaData().getVersion());
            s.standby();
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Named
    private static class BindAsLifecycle
    extends BindAsLifecycleSupport<QuartzSchedulerProvider> {
        private BindAsLifecycle() {
        }
    }
}

