/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.impl.jdbcjobstore.HSQLDBDelegate;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.spi.JobStore;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.BindAsLifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.quartz.orient.OrientDelegate;

@FeatureFlag(name="nexus.quartz.jobstore.jdbc")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class JobStoreJdbcProvider
extends LifecycleSupport
implements Provider<JobStore> {
    private static final String QUARTZ_DS = "quartzDS";
    private final ConnectionProvider connectionProvider;
    private final boolean datastoreClustered;
    private volatile JobStore jobStore;
    private final NodeAccess nodeAccess;

    @Inject
    public JobStoreJdbcProvider(ConnectionProvider connectionProvider, NodeAccess nodeAccess, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean datastoreClustered) {
        this.connectionProvider = connectionProvider;
        this.nodeAccess = nodeAccess;
        this.datastoreClustered = datastoreClustered;
    }

    protected void doStop() {
        if (this.jobStore != null) {
            this.jobStore.shutdown();
            this.jobStore = null;
            try {
                this.connectionProvider.shutdown();
            }
            catch (SQLException e) {
                this.log.error("Error while stopping job store", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStore get() {
        JobStore localRef = this.jobStore;
        if (localRef == null) {
            JobStoreJdbcProvider jobStoreJdbcProvider = this;
            synchronized (jobStoreJdbcProvider) {
                localRef = this.jobStore;
                if (localRef == null) {
                    this.jobStore = localRef = this.createJobStore();
                }
            }
        }
        return localRef;
    }

    private JobStore createJobStore() {
        try {
            this.connectionProvider.initialize();
            DBConnectionManager.getInstance().addConnectionProvider(QUARTZ_DS, this.connectionProvider);
            JobStoreTX delegate = new JobStoreTX();
            delegate.setDataSource(QUARTZ_DS);
            if (this.datastoreClustered) {
                this.log.info("Running Quartz in clustered mode");
                delegate.setIsClustered(true);
                delegate.setInstanceName(this.nodeAccess.getId());
                delegate.setInstanceId("AUTO");
            }
            delegate.setDriverDelegateClass(this.getDriverDelegateClass());
            return delegate;
        }
        catch (Exception e) {
            this.log.error("Unable create job store", (Throwable)e);
            return null;
        }
    }

    private String getDatabaseId() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection con = this.connectionProvider.getConnection();){
            return con.getMetaData().getDatabaseProductName();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getDriverDelegateClass() throws SQLException {
        switch (this.getDatabaseId()) {
            case "H2": {
                return HSQLDBDelegate.class.getName();
            }
            case "PostgreSQL": {
                return PostgreSQLDelegate.class.getName();
            }
            case "OrientDB": {
                return OrientDelegate.class.getName();
            }
        }
        return StdJDBCDelegate.class.getName();
    }

    @FeatureFlag(name="nexus.quartz.jobstore.jdbc")
    @Named
    private static class BindAsLifecycle
    extends BindAsLifecycleSupport<JobStoreJdbcProvider> {
        private BindAsLifecycle() {
        }
    }
}

