/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class JobFactoryImpl
extends ComponentSupport
implements JobFactory {
    private final Iterable<BeanEntry<Named, Job>> entries;

    @Inject
    public JobFactoryImpl(Iterable<BeanEntry<Named, Job>> entries) {
        this.entries = (Iterable)Preconditions.checkNotNull(entries);
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Class type = bundle.getJobDetail().getJobClass();
        this.log.debug("New job: {}", (Object)type);
        BeanEntry<Named, Job> beanEntry = this.locate(type);
        if (beanEntry == null) {
            throw new SchedulerException("Missing Job component for type: " + type.getName());
        }
        return (Job)beanEntry.getProvider().get();
    }

    @Nullable
    private BeanEntry<Named, Job> locate(Class<? extends Job> jobType) {
        for (BeanEntry<Named, Job> jobEntry : this.entries) {
            if (!jobEntry.getImplementationClass().equals(jobType)) continue;
            return jobEntry;
        }
        return null;
    }
}

