/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx.reflect;

import com.google.common.base.Preconditions;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.management.Descriptor;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBeanOperation;
import org.sonatype.nexus.jmx.OperationKey;
import org.sonatype.nexus.jmx.reflect.DescriptorHelper;

public class ReflectionMBeanOperation
extends ComponentSupport
implements MBeanOperation {
    private final MBeanOperationInfo info;
    private final String name;
    private final OperationKey key;
    private final Supplier target;
    private final Method method;

    public ReflectionMBeanOperation(MBeanOperationInfo info, Supplier target, Method method) {
        this.info = (MBeanOperationInfo)Preconditions.checkNotNull((Object)info);
        this.name = info.getName();
        this.key = new OperationKey(info);
        this.target = (Supplier)Preconditions.checkNotNull((Object)target);
        this.method = (Method)Preconditions.checkNotNull((Object)method);
    }

    @Override
    public MBeanOperationInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OperationKey getKey() {
        return this.key;
    }

    public Supplier getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    private Object target() {
        Object result = this.target.get();
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        return result;
    }

    @Override
    @Nullable
    public Object invoke(Object[] params) throws Exception {
        this.log.trace("Invoke: {} -> {}", Arrays.asList(params), (Object)this.method);
        return this.method.invoke(this.target(), params);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + ", key=" + this.key + '}';
    }

    public static class Builder
    extends ComponentSupport {
        private String name;
        private String description;
        private Supplier target;
        private Method method;
        private int impact = 3;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder target(Supplier target) {
            this.target = target;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder impact(int impact) {
            this.impact = impact;
            return this;
        }

        public ReflectionMBeanOperation build() {
            Preconditions.checkState((this.target != null ? 1 : 0) != 0);
            Preconditions.checkState((this.method != null ? 1 : 0) != 0);
            if (this.name == null) {
                this.name = this.method.getName();
            }
            MBeanOperationInfo info = new MBeanOperationInfo(this.name, this.description, this.signature(this.method), this.method.getReturnType().getName(), this.impact, DescriptorHelper.build(this.method));
            this.log.trace("Building operation with info: {}", (Object)info);
            return new ReflectionMBeanOperation(info, this.target, this.method);
        }

        private MBeanParameterInfo[] signature(Method method) {
            BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
            String[] names = paranamer.lookupParameterNames((AccessibleObject)method);
            Class<?>[] types = method.getParameterTypes();
            Annotation[][] annotations = method.getParameterAnnotations();
            MBeanParameterInfo[] result = new MBeanParameterInfo[names.length];
            int i = 0;
            while (i < names.length) {
                Descriptor descriptor = DescriptorHelper.build(annotations[i]);
                String description = DescriptorHelper.stringValue(descriptor, "description");
                result[i] = new MBeanParameterInfo(names[i], types[i].getName(), description, descriptor);
                ++i;
            }
            return result;
        }
    }
}

