/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBeanAttribute;
import org.sonatype.nexus.jmx.reflect.DescriptorHelper;

public class ReflectionMBeanAttribute
extends ComponentSupport
implements MBeanAttribute {
    private final MBeanAttributeInfo info;
    private final String name;
    private final Supplier target;
    private final Method getter;
    private final Method setter;

    public ReflectionMBeanAttribute(MBeanAttributeInfo info, Supplier target, @Nullable Method getter, @Nullable Method setter) {
        this.info = (MBeanAttributeInfo)Preconditions.checkNotNull((Object)info);
        this.name = info.getName();
        this.target = (Supplier)Preconditions.checkNotNull((Object)target);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public MBeanAttributeInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Supplier getTarget() {
        return this.target;
    }

    @Nullable
    public Method getGetter() {
        return this.getter;
    }

    @Nullable
    public Method getSetter() {
        return this.setter;
    }

    private Object target() {
        Object result = this.target.get();
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        return result;
    }

    @Override
    @Nullable
    public Object getValue() throws Exception {
        Preconditions.checkState((this.getter != null ? 1 : 0) != 0);
        this.log.trace("Get value: {}", (Object)this.getter);
        return this.getter.invoke(this.target(), new Object[0]);
    }

    @Override
    public void setValue(@Nullable Object value) throws Exception {
        Preconditions.checkState((this.setter != null ? 1 : 0) != 0);
        this.log.trace("Set value: {} -> {}", value, (Object)this.setter);
        this.setter.invoke(this.target(), value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + '}';
    }

    public static class Builder
    extends ComponentSupport {
        private String name;
        private String description;
        private Supplier target;
        private Method getter;
        private Method setter;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder target(Supplier target) {
            this.target = target;
            return this;
        }

        public Builder getter(Method getter) {
            this.getter = getter;
            return this;
        }

        public Builder setter(Method setter) {
            this.setter = setter;
            return this;
        }

        public ReflectionMBeanAttribute build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0);
            Preconditions.checkState((this.target != null ? 1 : 0) != 0);
            Preconditions.checkState((this.getter != null || this.setter != null ? 1 : 0) != 0);
            Descriptor getterDescriptor = null;
            if (this.getter != null) {
                getterDescriptor = DescriptorHelper.build(this.getter);
            }
            Descriptor setterDescriptor = null;
            if (this.setter != null) {
                setterDescriptor = DescriptorHelper.build(this.setter);
            }
            MBeanAttributeInfo info = new MBeanAttributeInfo(this.name, this.attributeType(this.getter, this.setter).getName(), this.description, this.getter != null, this.setter != null, this.isIs(this.getter), ImmutableDescriptor.union(getterDescriptor, setterDescriptor));
            this.log.trace("Building attribute with info: {}", (Object)info);
            return new ReflectionMBeanAttribute(info, this.target, this.getter, this.setter);
        }

        private Class<?> attributeType(Method getter, Method setter) {
            if (getter != null) {
                return getter.getReturnType();
            }
            return setter.getParameterTypes()[0];
        }

        private boolean isIs(Method getter) {
            return getter != null && getter.getName().startsWith("is");
        }
    }
}

