/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBeanAttribute;

public class SuppliedMBeanAttribute
extends ComponentSupport
implements MBeanAttribute {
    private final MBeanAttributeInfo info;
    private final String name;
    private final Supplier supplier;

    public SuppliedMBeanAttribute(MBeanAttributeInfo info, Supplier supplier) {
        this.info = (MBeanAttributeInfo)Preconditions.checkNotNull((Object)info);
        this.name = info.getName();
        this.supplier = (Supplier)Preconditions.checkNotNull((Object)supplier);
    }

    @Override
    public MBeanAttributeInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.supplier.get();
    }

    @Override
    public void setValue(Object value) throws Exception {
        throw new AttributeNotFoundException("Attribute is read-only: " + this.name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + ", supplier=" + this.supplier + '}';
    }

    public static class Builder
    extends ComponentSupport {
        private String name;
        private String description;
        private String type;
        private Supplier supplier;
        private Descriptor descriptor;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder type(Class<?> type) {
            this.type = type.getName();
            return this;
        }

        public Builder supplier(Supplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public Builder value(@Nullable Object value) {
            this.supplier = () -> value;
            if (value != null) {
                this.type(value.getClass());
            }
            return this;
        }

        public Builder descriptor(Descriptor descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public SuppliedMBeanAttribute build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0);
            Preconditions.checkState((this.supplier != null ? 1 : 0) != 0);
            if (this.type == null) {
                Object value = this.supplier.get();
                Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"Can not resolve type from supplier, value is null;  Configure type specifically");
                this.type = value.getClass().getName();
            }
            MBeanAttributeInfo info = new MBeanAttributeInfo(this.name, this.type, this.description, true, false, false, this.descriptor);
            this.log.trace("Building attribute with info: {}", (Object)info);
            return new SuppliedMBeanAttribute(info, this.supplier);
        }
    }
}

