/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class OperationKey {
    private final String name;
    private final List<String> types;

    public OperationKey(String name, String[] types) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)types);
        this.types = ImmutableList.copyOf((Object[])types);
    }

    public OperationKey(MBeanOperationInfo info) {
        Preconditions.checkNotNull((Object)info);
        this.name = info.getName();
        ImmutableList.Builder builder = ImmutableList.builder();
        MBeanParameterInfo[] mBeanParameterInfoArray = info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo pinfo = mBeanParameterInfoArray[n2];
            builder.add((Object)pinfo.getType());
            ++n2;
        }
        this.types = builder.build();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationKey operationKey = (OperationKey)o;
        if (this.name != null ? !this.name.equals(operationKey.name) : operationKey.name != null) {
            return false;
        }
        return !(this.types != null ? !this.types.equals(operationKey.types) : operationKey.types != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name).append('(');
        Iterator<String> iter = this.types.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(',');
        }
        buff.append(')');
        return buff.toString();
    }
}

