/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBean;
import org.sonatype.nexus.jmx.MBeanAttribute;
import org.sonatype.nexus.jmx.MBeanOperation;

public class MBeanBuilder
extends ComponentSupport {
    private final String className;
    protected final List<MBeanAttribute> attributes = Lists.newArrayList();
    protected final List<MBeanOperation> operations = Lists.newArrayList();
    private String description;
    private Descriptor descriptor;

    public MBeanBuilder(String className) {
        this.className = (String)Preconditions.checkNotNull((Object)className);
    }

    public MBeanBuilder description(String description) {
        this.description = description;
        return this;
    }

    public MBeanBuilder descriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public void attribute(MBeanAttribute attribute) {
        Preconditions.checkNotNull((Object)attribute);
        this.log.debug("Adding attribute: {}", (Object)attribute);
        this.attributes.add(attribute);
    }

    public void operation(MBeanOperation operation) {
        Preconditions.checkNotNull((Object)operation);
        this.log.debug("Adding operation: {}", (Object)operation);
        this.operations.add(operation);
    }

    public MBean build() {
        ArrayList ainfos = Lists.newArrayListWithCapacity((int)this.attributes.size());
        for (MBeanAttribute attribute : this.attributes) {
            ainfos.add(attribute.getInfo());
        }
        ArrayList oinfos = Lists.newArrayListWithCapacity((int)this.operations.size());
        for (MBeanOperation operation : this.operations) {
            oinfos.add(operation.getInfo());
        }
        MBeanConstructorInfo[] cinfos = new MBeanConstructorInfo[]{};
        MBeanNotificationInfo[] ninfos = new MBeanNotificationInfo[]{};
        MBeanInfo info = new MBeanInfo(this.className, this.description, ainfos.toArray(new MBeanAttributeInfo[ainfos.size()]), cinfos, oinfos.toArray(new MBeanOperationInfo[oinfos.size()]), ninfos, this.descriptor);
        this.log.trace("Building mbean with info: {}", (Object)info);
        return new MBean(info, this.attributes, this.operations);
    }
}

