/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.swagger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.swagger.SwaggerContributor;

public abstract class ParameterContributor<T extends AbstractSerializableParameter>
extends ComponentSupport
implements SwaggerContributor {
    private final Collection<HttpMethod> httpMethods;
    private final Collection<String> paths;
    private final Collection<T> params;
    @VisibleForTesting
    final Map<String, Boolean> contributed;
    private boolean allContributed;

    public ParameterContributor(Collection<HttpMethod> httpMethods, Collection<String> paths, Collection<T> params) {
        this.httpMethods = (Collection)Preconditions.checkNotNull(httpMethods);
        this.paths = (Collection)Preconditions.checkNotNull(paths);
        this.params = (Collection)Preconditions.checkNotNull(params);
        this.contributed = httpMethods.stream().flatMap(httpMethod -> paths.stream().map(path -> ParameterContributor.getKey(httpMethod, path))).collect(Collectors.toMap(p -> p, p -> false));
    }

    @Override
    public void contribute(Swagger swagger) {
        if (this.allContributed) {
            return;
        }
        for (HttpMethod httpMethod : this.httpMethods) {
            for (String path : this.paths) {
                this.contributed.compute(ParameterContributor.getKey(httpMethod, path), (key, value) -> value != false || this.contributeGetParameters(swagger, httpMethod, path, this.params));
            }
        }
        this.allContributed = this.contributed.entrySet().stream().allMatch(Map.Entry::getValue);
    }

    private boolean contributeGetParameters(Swagger swagger, HttpMethod httpMethod, String path, Collection<T> parameters) {
        boolean contrib = false;
        Optional<Operation> operation = this.getOperation(swagger, httpMethod, path);
        if (operation.isPresent()) {
            Operation op = operation.get();
            parameters.forEach(param -> {
                if (!op.getParameters().contains(param)) {
                    this.log.debug("adding {}, method: {}, path: {}, parameter: {}", new Object[]{param.getClass().getSimpleName(), httpMethod, path, param.getName()});
                    op.addParameter((Parameter)param);
                }
            });
            contrib = true;
        }
        return contrib;
    }

    private Optional<Operation> getOperation(Swagger swagger, HttpMethod httpMethod, String path) {
        return Optional.ofNullable(swagger.getPaths()).orElseGet(Collections::emptyMap).entrySet().stream().filter(e -> path.equals(e.getKey())).findFirst().map(Map.Entry::getValue).map(Path::getOperationMap).map(m -> (Operation)m.get(httpMethod));
    }

    private static String getKey(HttpMethod httpMethod, String path) {
        return String.format("%s-%s", httpMethod.name(), path);
    }
}

