/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.npm.metadata.export;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmPackageRootExporter {
    private static final Logger log = LoggerFactory.getLogger(NpmPackageRootExporter.class);

    public static void export(String npmPackageId, String packageRootJson, String exportDirectory) throws IOException {
        NpmPackageId packageId = NpmPackageId.parse(npmPackageId);
        File npmDir = NpmPackageRootExporter.getNpmDir(exportDirectory, packageId);
        String fileName = NpmPackageRootExporter.getFileName(packageId);
        File packageRootMetadataJsonFile = new File(npmDir, fileName);
        log.info("Writing to {}", (Object)packageRootMetadataJsonFile);
        if (packageRootMetadataJsonFile.exists()) {
            log.info("Already exists. Rewriting {}", (Object)packageRootMetadataJsonFile);
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileWriter fileWriter = new FileWriter(packageRootMetadataJsonFile);){
            fileWriter.write(packageRootJson);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static File getNpmDir(String exportDir, NpmPackageId packageId) {
        String scopePrefix = StringUtils.isEmpty((CharSequence)packageId.scope) ? "" : "@" + packageId.scope + "/";
        File dir = new File(exportDir, String.valueOf(scopePrefix) + packageId.name + "/-/");
        if (!dir.exists()) {
            log.info("Creating npm directory {}", (Object)dir);
            dir.mkdirs();
        }
        return dir;
    }

    private static String getFileName(NpmPackageId packageId) {
        return String.valueOf(packageId.name) + ".package.json";
    }

    private static class NpmPackageId {
        private final String scope;
        private final String name;

        private NpmPackageId(String scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public static NpmPackageId parse(String npmPackageName) {
            if (StringUtils.isEmpty((CharSequence)npmPackageName)) {
                throw new IllegalArgumentException("Package name is required.");
            }
            String scope = null;
            String name = npmPackageName;
            int slashIndex = name.indexOf(47);
            if (npmPackageName.startsWith("@") && slashIndex > -1) {
                scope = name.substring(1, slashIndex);
                name = name.substring(slashIndex + 1);
            }
            return new NpmPackageId(scope, name);
        }
    }
}

