/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.pax.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.sonatype.nexus.logging.task.TaskLoggerHelper;
import org.sonatype.nexus.logging.task.TaskLoggingEvent;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class TaskLogsFilter
extends Filter<ILoggingEvent> {
    @Override
    public FilterReply decide(ILoggingEvent event) {
        Marker marker = event.getMarker();
        if (TaskLoggingMarkers.PROGRESS.equals((Object)marker)) {
            TaskLoggerHelper.progress((TaskLoggingEvent)this.toTaskLoggerEvent(event));
        }
        if (!this.isExecutingInTask()) {
            return FilterReply.DENY;
        }
        if (TaskLoggingMarkers.NEXUS_LOG_ONLY.equals((Object)marker) || TaskLoggingMarkers.INTERNAL_PROGRESS.equals((Object)marker)) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    protected boolean isExecutingInTask() {
        return MDC.get((String)"taskIdAndDate") != null;
    }

    protected TaskLoggingEvent toTaskLoggerEvent(ILoggingEvent event) {
        Logger logger = LoggerFactory.getLogger((String)event.getLoggerName());
        return new TaskLoggingEvent(logger, event.getMessage(), event.getArgumentArray());
    }
}

