/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.pax.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Arrays;
import java.util.List;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class NexusLogFilter
extends Filter<ILoggingEvent> {
    private static final List<Marker> DENY_MARKERS = Arrays.asList(TaskLoggingMarkers.PROGRESS, TaskLoggingMarkers.TASK_LOG_ONLY, TaskLoggingMarkers.CLUSTER_LOG_ONLY, TaskLoggingMarkers.AUDIT_LOG_ONLY, TaskLoggingMarkers.OUTBOUND_REQUESTS_LOG_ONLY);

    @Override
    public FilterReply decide(ILoggingEvent event) {
        Marker marker = event.getMarker();
        if (MDC.get((String)"TASK_LOG_WITH_PROGRESS_MDC") != null && TaskLoggingMarkers.INTERNAL_PROGRESS.equals((Object)marker)) {
            return FilterReply.NEUTRAL;
        }
        if (DENY_MARKERS.stream().anyMatch(m -> m.equals((Object)marker)) || MDC.get((String)"TASK_LOG_ONLY_MDC") != null) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }
}

