/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerState;
import reactor.netty.http.server.ServerCookies;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.WebsocketServerOperations;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class HttpServerOperations
extends HttpOperations<HttpServerRequest, HttpServerResponse>
implements HttpServerRequest,
HttpServerResponse {
    final BiPredicate<HttpServerRequest, HttpServerResponse> configuredCompressionPredicate;
    final ConnectionInfo connectionInfo;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookies cookieHolder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final boolean isHttp2;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final HttpRequest nettyRequest;
    final HttpResponse nettyResponse;
    final HttpHeaders responseHeaders;
    final String scheme;
    final ZonedDateTime timestamp;
    BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate;
    Function<? super String, Map<String, String>> paramsResolver;
    String path;
    Consumer<? super HttpHeaders> trailerHeadersConsumer;
    volatile Context currentContext;
    static final Logger log = Loggers.getLogger(HttpServerOperations.class);
    static final AsciiString EVENT_STREAM = new AsciiString("text/event-stream");
    static final BiPredicate<HttpServerRequest, HttpServerResponse> COMPRESSION_DISABLED = (req, res) -> false;
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    HttpServerOperations(HttpServerOperations replaced) {
        super(replaced);
        this.compressionPredicate = replaced.compressionPredicate;
        this.configuredCompressionPredicate = replaced.configuredCompressionPredicate;
        this.connectionInfo = replaced.connectionInfo;
        this.cookieDecoder = replaced.cookieDecoder;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieHolder = replaced.cookieHolder;
        this.currentContext = replaced.currentContext;
        this.formDecoderProvider = replaced.formDecoderProvider;
        this.isHttp2 = replaced.isHttp2;
        this.mapHandle = replaced.mapHandle;
        this.nettyRequest = replaced.nettyRequest;
        this.nettyResponse = replaced.nettyResponse;
        this.paramsResolver = replaced.paramsResolver;
        this.path = replaced.path;
        this.responseHeaders = replaced.responseHeaders;
        this.scheme = replaced.scheme;
        this.timestamp = replaced.timestamp;
        this.trailerHeadersConsumer = replaced.trailerHeadersConsumer;
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, boolean secured, ZonedDateTime timestamp) {
        this(c, listener, nettyRequest, compressionPredicate, connectionInfo, decoder, encoder, formDecoderProvider, httpMessageLogFactory, isHttp2, mapHandle, true, secured, timestamp);
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, boolean resolvePath, boolean secured, ZonedDateTime timestamp) {
        super(c, listener, httpMessageLogFactory);
        this.compressionPredicate = compressionPredicate;
        this.configuredCompressionPredicate = compressionPredicate;
        this.connectionInfo = connectionInfo;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.cookieHolder = ServerCookies.newServerRequestHolder(nettyRequest.headers(), decoder);
        this.currentContext = Context.empty();
        this.formDecoderProvider = formDecoderProvider;
        this.isHttp2 = isHttp2;
        this.mapHandle = mapHandle;
        this.nettyRequest = nettyRequest;
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.path = resolvePath ? HttpServerOperations.resolvePath(nettyRequest.uri()) : null;
        this.responseHeaders = this.nettyResponse.headers();
        this.responseHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.scheme = secured ? "https" : "http";
        this.timestamp = timestamp;
    }

    @Override
    public NettyOutbound sendHeaders() {
        if (this.hasSentHeaders()) {
            return this;
        }
        return this.then(Mono.empty());
    }

    @Override
    public HttpServerOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    protected HttpMessage newFullBodyMessage(ByteBuf body) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(this.version(), this.status(), body);
        if (!HttpMethod.HEAD.equals(this.method())) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            int code = this.status().code();
            if (HttpResponseStatus.NOT_MODIFIED.code() != code && HttpResponseStatus.NO_CONTENT.code() != code && HttpUtil.getContentLength((HttpMessage)this.nettyResponse, -1) == -1) {
                this.responseHeaders.setInt(HttpHeaderNames.CONTENT_LENGTH, body.readableBytes());
            }
        } else if (HttpUtil.getContentLength((HttpMessage)this.nettyResponse, -1) != -1) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        }
        res.headers().set(this.responseHeaders);
        return res;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpServerResponse addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerOperations chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked(this.nettyResponse) != chunked) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.nettyResponse, chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public Map<CharSequence, List<Cookie>> allCookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getAllCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public Context currentContext() {
        return this.currentContext;
    }

    @Override
    public HttpServerResponse header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(headers);
        return this;
    }

    @Override
    public boolean isFormUrlencoded() {
        CharSequence mimeType = HttpUtil.getMimeType(this.nettyRequest);
        return mimeType != null && HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEqualsIgnoreCase(mimeType.toString().trim());
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive(this.nettyRequest);
    }

    @Override
    public boolean isMultipart() {
        return HttpPostRequestDecoder.isMultipart(this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return HttpServerOperations.get(this.channel()) instanceof WebsocketServerOperations;
    }

    final boolean isHttp2() {
        return this.isHttp2;
    }

    @Override
    public HttpServerResponse keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive(this.nettyResponse, keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    @Nullable
    public String param(CharSequence key) {
        Objects.requireNonNull(key, "key");
        Map<String, String> params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.apply(this.uri());
        }
        return null != params ? params.get(key.toString()) : null;
    }

    @Override
    @Nullable
    public Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.apply(this.uri()) : null;
    }

    @Override
    public HttpServerRequest paramsResolver(Function<? super String, Map<String, String>> paramsResolver) {
        this.paramsResolver = paramsResolver;
        return this;
    }

    @Override
    public Flux<HttpData> receiveForm() {
        return this.receiveFormInternal(this.formDecoderProvider);
    }

    @Override
    public Flux<HttpData> receiveForm(Consumer<HttpServerFormDecoderProvider.Builder> formDecoderBuilder) {
        Objects.requireNonNull(formDecoderBuilder, "formDecoderBuilder");
        HttpServerFormDecoderProvider.Build builder = new HttpServerFormDecoderProvider.Build();
        formDecoderBuilder.accept(builder);
        HttpServerFormDecoderProvider config = builder.build();
        return this.receiveFormInternal(config);
    }

    @Override
    public Flux<?> receiveObject() {
        if (HttpUtil.is100ContinueExpected(this.nettyRequest)) {
            return FutureMono.deferFuture(() -> {
                if (!this.hasSentHeaders()) {
                    return this.channel().writeAndFlush(CONTINUE);
                }
                return this.channel().newSucceededFuture();
            }).thenMany(super.receiveObject());
        }
        return super.receiveObject();
    }

    @Override
    @Nullable
    public InetSocketAddress hostAddress() {
        return this.connectionInfo.getHostAddress();
    }

    final SocketAddress hostSocketAddress() {
        return this.connectionInfo.hostAddress;
    }

    @Override
    @Nullable
    public SocketAddress connectionHostAddress() {
        return this.channel().localAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        return this.connectionInfo.getRemoteAddress();
    }

    final SocketAddress remoteSocketAddress() {
        return this.connectionInfo.remoteAddress;
    }

    @Override
    @Nullable
    public SocketAddress connectionRemoteAddress() {
        return this.channel().remoteAddress();
    }

    @Override
    public HttpHeaders requestHeaders() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.headers();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String scheme() {
        return this.connectionInfo.getScheme();
    }

    @Override
    public String connectionScheme() {
        return this.scheme;
    }

    @Override
    public String hostName() {
        return this.connectionInfo.getHostName();
    }

    @Override
    public int hostPort() {
        return this.connectionInfo.getHostPort();
    }

    @Override
    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public String protocol() {
        return this.nettyRequest.protocolVersion().text();
    }

    @Override
    public ZonedDateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public Mono<Void> send() {
        return FutureMono.deferFuture(() -> this.markSentHeaderAndBody(new Object[0]) ? this.channel().writeAndFlush(this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)) : this.channel().newSucceededFuture());
    }

    @Override
    public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Path not resolved"), e);
            }
            return this.then(this.sendNotFound());
        }
    }

    @Override
    public Mono<Void> sendNotFound() {
        return this.status(HttpResponseStatus.NOT_FOUND).send();
    }

    @Override
    public Mono<Void> sendRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return this.status(HttpResponseStatus.FOUND).header(HttpHeaderNames.LOCATION, location).send();
    }

    @Override
    public HttpServerResponse sse() {
        this.header(HttpHeaderNames.CONTENT_TYPE, EVENT_STREAM);
        return this;
    }

    @Override
    public HttpResponseStatus status() {
        return this.nettyResponse.status();
    }

    @Override
    public HttpServerResponse status(HttpResponseStatus status) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.nettyResponse.setStatus(status);
        return this;
    }

    @Override
    public HttpServerResponse trailerHeaders(Consumer<? super HttpHeaders> trailerHeaders) {
        this.trailerHeadersConsumer = Objects.requireNonNull(trailerHeaders, "trailerHeaders");
        return this;
    }

    @Override
    public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler, WebsocketServerSpec configurer) {
        return this.withWebsocketSupport(this.uri(), configurer, websocketHandler);
    }

    @Override
    public String uri() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.uri();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String fullPath() {
        if (this.path != null) {
            return this.path;
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.protocolVersion();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse compression(boolean compress) {
        BiPredicate<HttpServerRequest, HttpServerResponse> biPredicate = this.compressionPredicate = compress ? this.configuredCompressionPredicate : COMPRESSION_DISABLED;
        if (!compress) {
            this.removeHandler("reactor.left.compressionHandler");
        } else if (this.channel().pipeline().get("reactor.left.compressionHandler") == null) {
            SimpleCompressionHandler handler = new SimpleCompressionHandler();
            try {
                handler.decode(this.channel().pipeline().context("reactor.right.reactiveBridge"), this.nettyRequest);
                this.addHandlerFirst("reactor.left.compressionHandler", handler);
            }
            catch (Throwable e) {
                log.error(ReactorNetty.format(this.channel(), ""), e);
            }
        }
        return this;
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            try {
                this.listener().onStateChange(this, HttpServerState.REQUEST_RECEIVED);
            }
            catch (Exception e) {
                this.onInboundError(e);
                ReferenceCountUtil.release(msg);
                return;
            }
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                if (request.content().readableBytes() > 0) {
                    super.onInboundNext(ctx, msg);
                } else {
                    request.release();
                }
                if (this.isHttp2()) {
                    this.channel().config().setAutoRead(true);
                    this.onInboundComplete();
                }
            }
            return;
        }
        if (msg instanceof HttpContent) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            if (msg instanceof LastHttpContent) {
                this.channel().config().setAutoRead(true);
                this.onInboundComplete();
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void onInboundClose() {
        this.discardWhenNoReceiver();
        if (!this.isInboundCancelled() && !this.isInboundDisposed()) {
            this.onInboundError(new AbortedException("Connection has been closed"));
        }
        this.terminate();
    }

    @Override
    protected void afterMarkSentHeaders() {
        if (this.compressionPredicate != null && this.compressionPredicate.test(this, this)) {
            this.compression(true);
        }
    }

    @Override
    protected void beforeMarkSentHeaders() {
    }

    @Override
    protected boolean isContentAlwaysEmpty() {
        int code = this.status().code();
        if (HttpResponseStatus.NOT_MODIFIED.code() == code) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING).remove(HttpHeaderNames.CONTENT_LENGTH);
            return true;
        }
        return HttpResponseStatus.NO_CONTENT.code() == code || HttpResponseStatus.RESET_CONTENT.code() == code;
    }

    @Override
    protected void onHeadersSent() {
    }

    @Override
    protected void onOutboundComplete() {
        ChannelFuture f;
        if (this.isWebsocket()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Last HTTP response frame"));
        }
        if (this.markSentHeaderAndBody(new Object[0])) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            f = this.channel().writeAndFlush(this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
        } else if (this.markSentBody()) {
            String declaredHeaderNames;
            HttpHeaders trailerHeaders = null;
            if (this.trailerHeadersConsumer != null && HttpUtil.isTransferEncodingChunked(this.nettyResponse) && (declaredHeaderNames = this.responseHeaders.get(HttpHeaderNames.TRAILER)) != null) {
                trailerHeaders = new TrailerHeaders(declaredHeaderNames);
                try {
                    this.trailerHeadersConsumer.accept(trailerHeaders);
                }
                catch (IllegalArgumentException e) {
                    log.error(ReactorNetty.format(this.channel(), "Cannot apply trailer headers [{}]"), declaredHeaderNames, e);
                }
            }
            f = this.channel().writeAndFlush(trailerHeaders != null && !trailerHeaders.isEmpty() ? new DefaultLastHttpContent(Unpooled.buffer(0), trailerHeaders) : LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            this.discard();
            return;
        }
        f.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)s -> {
            this.discard();
            if (!s.isSuccess() && log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Failed flushing last frame"), s.cause());
            }
        }));
    }

    static void cleanHandlerTerminate(Channel ch) {
        ChannelOperations<?, ?> ops = HttpServerOperations.get(ch);
        if (ops == null) {
            return;
        }
        ops.discard();
        if (!ops.isSubscriptionDisposed()) {
            ch.eventLoop().execute(((HttpServerOperations)ops)::terminate);
        } else {
            ((HttpServerOperations)ops).terminate();
        }
    }

    static long requestsCounter(Channel channel) {
        HttpServerOperations ops = Connection.from(channel).as(HttpServerOperations.class);
        if (ops == null) {
            return -1L;
        }
        return ((AtomicLong)((Object)ops.connection())).get();
    }

    static void sendDecodingFailures(ChannelHandlerContext ctx, ConnectionObserver listener, boolean secure, Throwable t, Object msg, HttpMessageLogFactory httpMessageLogFactory, @Nullable ZonedDateTime timestamp, @Nullable ConnectionInfo connectionInfo, SocketAddress remoteAddress) {
        HttpServerOperations.sendDecodingFailures(ctx, listener, secure, t, msg, httpMessageLogFactory, false, timestamp, connectionInfo, remoteAddress);
    }

    static void sendDecodingFailures(ChannelHandlerContext ctx, ConnectionObserver listener, boolean secure, Throwable t, Object msg, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, @Nullable ZonedDateTime timestamp, @Nullable ConnectionInfo connectionInfo, SocketAddress remoteAddress) {
        Throwable cause;
        Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
        if (log.isWarnEnabled()) {
            log.warn(ReactorNetty.format(ctx.channel(), "Decoding failed: {}"), msg instanceof HttpObject ? httpMessageLogFactory.warn(HttpMessageArgProviderFactory.create(msg)) : msg);
        }
        ReferenceCountUtil.release(msg);
        HttpResponseStatus status = cause instanceof TooLongHttpLineException ? HttpResponseStatus.REQUEST_URI_TOO_LONG : (cause instanceof TooLongHttpHeaderException ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        FailedHttpServerRequest ops = ChannelOperations.get(ctx.channel());
        if (ops == null) {
            Connection conn = Connection.from(ctx.channel());
            if (msg instanceof HttpRequest) {
                ops = new FailedHttpServerRequest(conn, listener, (HttpRequest)msg, response, httpMessageLogFactory, isHttp2, secure, timestamp == null ? ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM) : timestamp, connectionInfo == null ? new ConnectionInfo(ctx.channel().localAddress(), remoteAddress, secure) : connectionInfo);
                ops.bind();
            } else {
                ops = conn;
            }
        }
        ctx.channel().writeAndFlush(response);
        listener.onStateChange(ops, HttpServerState.REQUEST_DECODING_FAILED);
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (!this.channel().isActive()) {
            super.onOutboundError(err);
            return;
        }
        if (this.markSentHeaders(new Object[0])) {
            log.error(ReactorNetty.format(this.channel(), "Error starting response. Replying error status"), err);
            this.nettyResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.channel().writeAndFlush(this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        this.markSentBody();
        log.error(ReactorNetty.format(this.channel(), "Error finishing response. Closing connection"), err);
        this.channel().writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyResponse;
    }

    final Flux<HttpData> receiveFormInternal(HttpServerFormDecoderProvider config) {
        boolean isMultipart = this.isMultipart();
        if (!Objects.equals(this.method(), HttpMethod.POST) || !this.isFormUrlencoded() && !isMultipart) {
            return Flux.error(new IllegalStateException("Request is not POST or does not have Content-Type with value 'application/x-www-form-urlencoded' or 'multipart/form-data'"));
        }
        return Flux.defer(() -> config.newHttpPostRequestDecoder(this.nettyRequest, isMultipart).flatMapMany(decoder -> this.receiveObject().concatMap(object -> {
            if (!(object instanceof HttpContent)) {
                return Mono.empty();
            }
            HttpContent httpContent = (HttpContent)object;
            if (config.maxInMemorySize > -1L) {
                httpContent.retain();
            }
            return config.maxInMemorySize == -1L ? Flux.using(() -> decoder.offer(httpContent), d -> Flux.fromIterable(decoder.currentHttpData(!config.streaming)), d -> decoder.cleanCurrentHttpData(!config.streaming)) : Flux.usingWhen(Mono.fromCallable(() -> decoder.offer(httpContent)).subscribeOn(config.scheduler).doFinally(sig -> httpContent.release()), d -> Flux.fromIterable(decoder.currentHttpData(true)), d -> Mono.fromRunnable(() -> decoder.cleanCurrentHttpData(true)));
        }, 0).doFinally(sig -> decoder.destroy())));
    }

    final Mono<Void> withWebsocketSupport(String url, WebsocketServerSpec websocketServerSpec, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketServerSpec, "websocketServerSpec");
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        if (this.markSentHeaders(new Object[0])) {
            WebsocketServerOperations ops = new WebsocketServerOperations(url, websocketServerSpec, this);
            return FutureMono.from(ops.handshakerResult).doOnEach(signal -> {
                if (!(signal.hasError() || websocketServerSpec.protocols() != null && ops.selectedSubprotocol() == null)) {
                    ((Publisher)websocketHandler.apply(ops, ops)).subscribe((Subscriber)new WebsocketSubscriber(ops, Context.of(signal.getContextView())));
                }
            });
        }
        log.error(ReactorNetty.format(this.channel(), "Cannot enable websocket if headers have already been sent"));
        return Mono.error(new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class TrailerHeaders
    extends DefaultHttpHeaders {
        static final Set<String> DISALLOWED_TRAILER_HEADER_NAMES = new HashSet<String>(14);

        TrailerHeaders(String declaredHeaderNames) {
            super(true, new TrailerNameValidator(TrailerHeaders.filterHeaderNames(declaredHeaderNames)));
        }

        static Set<String> filterHeaderNames(String declaredHeaderNames) {
            String[] names;
            Objects.requireNonNull(declaredHeaderNames, "declaredHeaderNames");
            HashSet<String> result = new HashSet<String>();
            for (String name : names = declaredHeaderNames.split(",", -1)) {
                String trimmedStr = name.trim();
                if (trimmedStr.isEmpty() || DISALLOWED_TRAILER_HEADER_NAMES.contains(trimmedStr.toLowerCase(Locale.ENGLISH))) continue;
                result.add(trimmedStr);
            }
            return result;
        }

        static {
            DISALLOWED_TRAILER_HEADER_NAMES.add("age");
            DISALLOWED_TRAILER_HEADER_NAMES.add("cache-control");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-length");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-range");
            DISALLOWED_TRAILER_HEADER_NAMES.add("content-type");
            DISALLOWED_TRAILER_HEADER_NAMES.add("date");
            DISALLOWED_TRAILER_HEADER_NAMES.add("expires");
            DISALLOWED_TRAILER_HEADER_NAMES.add("location");
            DISALLOWED_TRAILER_HEADER_NAMES.add("retry-after");
            DISALLOWED_TRAILER_HEADER_NAMES.add("trailer");
            DISALLOWED_TRAILER_HEADER_NAMES.add("transfer-encoding");
            DISALLOWED_TRAILER_HEADER_NAMES.add("vary");
            DISALLOWED_TRAILER_HEADER_NAMES.add("warning");
        }

        static final class TrailerNameValidator
        implements DefaultHeaders.NameValidator<CharSequence> {
            final Set<String> declaredHeaderNames;

            TrailerNameValidator(Set<String> declaredHeaderNames) {
                this.declaredHeaderNames = declaredHeaderNames;
            }

            @Override
            public void validateName(CharSequence name) {
                if (!this.declaredHeaderNames.contains(name.toString())) {
                    throw new IllegalArgumentException("Trailer header name [" + name + "] not declared with [Trailer] header, or it is not a valid trailer header name");
                }
            }
        }
    }

    static final class FailedHttpServerRequest
    extends HttpServerOperations {
        final HttpResponse customResponse;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FailedHttpServerRequest(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, HttpResponse nettyResponse, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, boolean secure, ZonedDateTime timestamp, ConnectionInfo connectionInfo) {
            super(c, listener, nettyRequest, null, connectionInfo, ServerCookieDecoder.STRICT, ServerCookieEncoder.STRICT, HttpServerFormDecoderProvider.DEFAULT_FORM_DECODER_SPEC, httpMessageLogFactory, isHttp2, null, false, secure, timestamp);
            this.customResponse = nettyResponse;
            String tempPath = "";
            try {
                tempPath = FailedHttpServerRequest.resolvePath(nettyRequest.uri());
            }
            catch (RuntimeException e) {
                tempPath = "/bad-request";
            }
            finally {
                this.path = tempPath;
            }
        }

        @Override
        protected HttpMessage outboundHttpMessage() {
            return this.customResponse;
        }

        @Override
        public HttpResponseStatus status() {
            return this.customResponse.status();
        }
    }

    static final class WebsocketSubscriber
    implements CoreSubscriber<Void>,
    ChannelFutureListener {
        final WebsocketServerOperations ops;
        final Context context;

        WebsocketSubscriber(WebsocketServerOperations ops, Context context) {
            this.ops = ops;
            this.context = context;
        }

        @Override
        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable t) {
            this.ops.onError(t);
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            ((HttpServerOperations)this.ops).terminate();
        }

        public void onComplete() {
            if (this.ops.channel().isActive()) {
                this.ops.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE), this);
            }
        }

        @Override
        public Context currentContext() {
            return this.context;
        }
    }
}

