/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.javac;

import groovy.lang.GroovyRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.codehaus.groovy.ast.ClassNode;

public class MemJavaFileObject
extends SimpleJavaFileObject {
    private final String className;
    private final String src;

    public MemJavaFileObject(ClassNode classNode, String src) {
        super(MemJavaFileObject.createURI(classNode), JavaFileObject.Kind.SOURCE);
        this.className = classNode.getName();
        this.src = src;
    }

    private static URI createURI(ClassNode classNode) {
        try {
            String packageName = classNode.getPackageName();
            String className = classNode.getNameWithoutPackage();
            return new URI("string:///" + (null == packageName ? "" : packageName.replace('.', '/') + "/") + className + ".java");
        }
        catch (URISyntaxException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.src;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemJavaFileObject)) {
            return false;
        }
        MemJavaFileObject that = (MemJavaFileObject)o;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }

    @Override
    public String toString() {
        return "MemJavaFileObject{className=" + this.className + '}';
    }
}

