/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.matcher;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MapWithDefault;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.macro.matcher.ASTNodePredicate;
import org.codehaus.groovy.macro.matcher.MatcherUtils;
import org.codehaus.groovy.macro.matcher.TreeContextAction;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class TreeContext {
    final TreeContext parent;
    final ASTNode node;
    final List<TreeContext> siblings = new LinkedList<TreeContext>();
    final List<TreeContextAction> onPopHandlers = new LinkedList<TreeContextAction>();
    final Map<Object, List<?>> userdata = MapWithDefault.newInstance(new HashMap(), (Closure)new Closure(this){
        private static final long serialVersionUID = -4694773031569936343L;

        public Object doCall(Object key) {
            return new LinkedList();
        }
    });

    TreeContext(TreeContext parent, ASTNode node) {
        this.parent = parent;
        this.node = node;
        if (parent != null) {
            parent.siblings.add(this);
        }
    }

    public Map<?, List<?>> getUserdata() {
        return this.userdata;
    }

    public void putUserdata(Object key, Object value) {
        this.userdata.get(key).add(value);
    }

    public List<?> getUserdata(Object key) {
        return this.getUserdata(key, true);
    }

    public List<?> getUserdata(Object key, boolean searchParent) {
        if (this.userdata.containsKey(key)) {
            return this.userdata.get(key);
        }
        if (this.parent != null && searchParent) {
            return this.parent.getUserdata(key, true);
        }
        return null;
    }

    public TreeContext getParent() {
        return this.parent;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public TreeContext fork(ASTNode node) {
        return new TreeContext(this, node);
    }

    public boolean matches(ASTNodePredicate predicate) {
        return predicate.matches(this.node);
    }

    public boolean matches(@DelegatesTo(value=ASTNode.class, strategy=1) Closure<Boolean> predicate) {
        return (Boolean)MatcherUtils.cloneWithDelegate(predicate, this.node).call();
    }

    public List<TreeContext> getSiblings() {
        return Collections.unmodifiableList(this.siblings);
    }

    public List<TreeContextAction> getOnPopHandlers() {
        return Collections.unmodifiableList(this.onPopHandlers);
    }

    public void afterVisit(TreeContextAction action) {
        this.onPopHandlers.add(action);
    }

    public void afterVisit(@DelegatesTo(value=TreeContext.class, strategy=1) Closure<?> action) {
        Closure<?> clone = MatcherUtils.cloneWithDelegate(action, this);
        this.afterVisit(DefaultGroovyMethods.asType(clone, TreeContextAction.class));
    }

    public void setReplacement(Expression replacement) {
        this.userdata.put((Object)TreeContextKey.expression_replacement, Collections.singletonList(replacement));
    }

    public Expression getReplacement() {
        List<?> list = this.userdata.get((Object)TreeContextKey.expression_replacement);
        if (list.size() == 1) {
            return (Expression)list.get(0);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TreeContext{");
        sb.append("node=").append(this.dumpNode());
        TreeContext p = this.parent;
        if (p != null) {
            sb.append(", path=");
        }
        while (p != null) {
            sb.append(p.dumpNode());
            sb.append("<-");
            p = p.parent;
        }
        sb.append('}');
        return sb.toString();
    }

    private String dumpNode() {
        return this.node != null ? this.node.getClass().getSimpleName() : "undefined";
    }

    private static enum TreeContextKey {
        expression_replacement;

    }
}

