/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.util;

import groovy.lang.Tuple2;
import groovyjarjarasm.asm.Type;
import java.util.Map;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;

public abstract class TypeUtil {
    private static final String REF_DESCRIPTION = "L";
    private static final Map<ClassNode, String> PRIMITIVE_TYPE_TO_DESCRIPTION_MAP = Maps.of((Object)ClassHelper.int_TYPE, (Object)"I", (Object)ClassHelper.VOID_TYPE, (Object)"V", (Object)ClassHelper.boolean_TYPE, (Object)"Z", (Object)ClassHelper.byte_TYPE, (Object)"B", (Object)ClassHelper.char_TYPE, (Object)"C", (Object)ClassHelper.short_TYPE, (Object)"S", (Object)ClassHelper.double_TYPE, (Object)"D", (Object)ClassHelper.float_TYPE, (Object)"F", (Object)ClassHelper.long_TYPE, (Object)"J");
    private static final Map<String, ClassNode> NAME_TO_PRIMITIVE_TYPE_MAP = Maps.of((Object)"int", (Object)ClassHelper.int_TYPE, (Object)"void", (Object)ClassHelper.VOID_TYPE, (Object)"boolean", (Object)ClassHelper.boolean_TYPE, (Object)"byte", (Object)ClassHelper.byte_TYPE, (Object)"char", (Object)ClassHelper.char_TYPE, (Object)"short", (Object)ClassHelper.short_TYPE, (Object)"double", (Object)ClassHelper.double_TYPE, (Object)"float", (Object)ClassHelper.float_TYPE, (Object)"long", (Object)ClassHelper.long_TYPE);
    private static final Map<Type, Integer> PRIMITIVE_TYPE_TO_LOAD_INSN_MAP = Maps.of((Object)Type.BOOLEAN_TYPE, (Object)21, (Object)Type.BYTE_TYPE, (Object)21, (Object)Type.CHAR_TYPE, (Object)21, (Object)Type.DOUBLE_TYPE, (Object)24, (Object)Type.FLOAT_TYPE, (Object)23, (Object)Type.INT_TYPE, (Object)21, (Object)Type.LONG_TYPE, (Object)22, (Object)Type.SHORT_TYPE, (Object)21);
    private static final Map<Type, Integer> PRIMITIVE_TYPE_TO_RETURN_INSN_MAP = Maps.of((Object)Type.BOOLEAN_TYPE, (Object)172, (Object)Type.BYTE_TYPE, (Object)172, (Object)Type.CHAR_TYPE, (Object)172, (Object)Type.DOUBLE_TYPE, (Object)175, (Object)Type.FLOAT_TYPE, (Object)174, (Object)Type.INT_TYPE, (Object)172, (Object)Type.LONG_TYPE, (Object)173, (Object)Type.SHORT_TYPE, (Object)172);
    private static final Map<Type, String> PRIMITIVE_TYPE_TO_WRAPPED_CLASS_DESCRIPTOR_MAP = Maps.of((Object)Type.BOOLEAN_TYPE, (Object)"java/lang/Boolean", (Object)Type.BYTE_TYPE, (Object)"java/lang/Byte", (Object)Type.CHAR_TYPE, (Object)"java/lang/Character", (Object)Type.DOUBLE_TYPE, (Object)"java/lang/Double", (Object)Type.FLOAT_TYPE, (Object)"java/lang/Float", (Object)Type.INT_TYPE, (Object)"java/lang/Integer", (Object)Type.LONG_TYPE, (Object)"java/lang/Long", (Object)Type.SHORT_TYPE, (Object)"java/lang/Short");
    private static final Map<Class, Class> PRIMITIVE_TYPE_TO_WRAPPED_CLASS_MAP = Maps.of(Byte.TYPE, Byte.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);

    public static Class autoboxType(Class type) {
        Class res = PRIMITIVE_TYPE_TO_WRAPPED_CLASS_MAP.get(type);
        return res == null ? type : res;
    }

    public static int getLoadInsnByType(Type type) {
        Integer insn = PRIMITIVE_TYPE_TO_LOAD_INSN_MAP.get(type);
        if (null != insn) {
            return insn;
        }
        return 25;
    }

    public static int getReturnInsnByType(Type type) {
        Integer insn = PRIMITIVE_TYPE_TO_RETURN_INSN_MAP.get(type);
        if (null != insn) {
            return insn;
        }
        return 176;
    }

    public static String getWrappedClassDescriptor(Type type) {
        String desc = PRIMITIVE_TYPE_TO_WRAPPED_CLASS_DESCRIPTOR_MAP.get(type);
        if (null != desc) {
            return desc;
        }
        throw new IllegalArgumentException("Unexpected type class [" + type + "]");
    }

    public static boolean isPrimitiveType(Type type) {
        return PRIMITIVE_TYPE_TO_LOAD_INSN_MAP.containsKey(type);
    }

    public static boolean isPrimitiveType(String name) {
        return NAME_TO_PRIMITIVE_TYPE_MAP.containsKey(name);
    }

    public static boolean isPrimitiveType(ClassNode type) {
        return PRIMITIVE_TYPE_TO_DESCRIPTION_MAP.containsKey(type);
    }

    public static String getDescriptionByType(ClassNode type) {
        String desc = PRIMITIVE_TYPE_TO_DESCRIPTION_MAP.get(type);
        if (null == desc) {
            if (!type.isArray()) {
                return TypeUtil.makeRefDescription(type.getName());
            }
            StringBuilder arrayDescription = new StringBuilder(32);
            Tuple2<ClassNode, Integer> arrayInfo = TypeUtil.extractArrayInfo(type);
            int dimension = (Integer)arrayInfo.getSecond();
            for (int i = 0; i < dimension; ++i) {
                arrayDescription.append("[");
            }
            ClassNode componentType = (ClassNode)arrayInfo.getV1();
            return arrayDescription.append(TypeUtil.getDescriptionByType(componentType)).toString();
        }
        return desc;
    }

    public static String getDescriptionByName(String name) {
        ClassNode type = NAME_TO_PRIMITIVE_TYPE_MAP.get(name);
        if (null == type) {
            return TypeUtil.makeRefDescription(name);
        }
        return TypeUtil.getDescriptionByType(type);
    }

    private static String makeRefDescription(String name) {
        return REF_DESCRIPTION + name.replace('.', '/') + ";";
    }

    private static Tuple2<ClassNode, Integer> extractArrayInfo(ClassNode type) {
        int dimension = 0;
        do {
            ++dimension;
        } while ((type = type.getComponentType()).isArray());
        return new Tuple2((Object)type, (Object)dimension);
    }
}

