/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiAuthentication;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureBlobStoreApiBucketConfiguration {
    @NotNull
    @ApiModelProperty(value="Account name found under Access keys for the storage account.", required=true)
    private String accountName;
    @NotNull
    @Pattern(regexp="^[a-z0-9][a-z0-9-]{2,62}$", message="Container names can contain only lowercase letters, numbers, and the dash (-) character, and must be 3-63 characters long.")
    @ApiModelProperty(value="The name of an existing container to be used for storage.", required=true)
    private @NotNull @Pattern(regexp="^[a-z0-9][a-z0-9-]{2,62}$", message="Container names can contain only lowercase letters, numbers, and the dash (-) character, and must be 3-63 characters long.") String containerName;
    @Valid
    @NotNull
    @ApiModelProperty(value="The Azure specific authentication details.")
    private AzureBlobStoreApiAuthentication authentication;

    public AzureBlobStoreApiBucketConfiguration() {
    }

    @JsonCreator
    public AzureBlobStoreApiBucketConfiguration(@JsonProperty(value="accountName") String accountName, @JsonProperty(value="containerName") String containerName, @JsonProperty(value="authentication") AzureBlobStoreApiAuthentication authentication) {
        this.accountName = accountName;
        this.containerName = containerName;
        this.authentication = authentication;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public AzureBlobStoreApiAuthentication getAuthentication() {
        return this.authentication;
    }
}

