/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal;

import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class AzureBlobStoreApiUpdateValidation {
    private static final String BLOB_STORE_NAME = "name";
    private static final String COMMA = ",";
    private final BlobStoreManager blobStoreManager;

    @Inject
    public AzureBlobStoreApiUpdateValidation(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    void validateUpdateRequest(AzureBlobStoreApiModel azureBlobStoreApiModel, String blobStoreName) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean blobStoreExists = this.checkBlobStoreExists(blobStoreName, errors);
        this.checkBlobStoreNamesMatch(azureBlobStoreApiModel, blobStoreName, errors);
        if (blobStoreExists) {
            this.checkBlobStoreTypeIsAzure(blobStoreName, errors);
        }
        if (!errors.isEmpty()) {
            throw new ValidationErrorsException(BLOB_STORE_NAME, String.join((CharSequence)COMMA, errors));
        }
    }

    private boolean checkBlobStoreExists(String blobStoreName, List<String> errors) {
        if (!this.blobStoreManager.exists(blobStoreName)) {
            errors.add(String.format("No Azure blob store called '%s'", blobStoreName));
            return false;
        }
        return true;
    }

    private void checkBlobStoreNamesMatch(AzureBlobStoreApiModel azureBlobStoreApiModel, String blobStoreName, List<String> errors) {
        if (!StringUtils.equalsIgnoreCase((String)azureBlobStoreApiModel.getName(), (String)blobStoreName)) {
            errors.add("Renaming an Azure blob store name is not supported");
        }
    }

    private void checkBlobStoreTypeIsAzure(String blobStoreName, List<String> errors) {
        if (this.existingBlobStoreIsNotAzure(blobStoreName)) {
            errors.add(String.format("Blob store %s is not an Azure blob store", blobStoreName));
        }
    }

    private boolean existingBlobStoreIsNotAzure(String blobStoreName) {
        return !Optional.ofNullable(this.blobStoreManager.get(blobStoreName)).map(BlobStore::getBlobStoreConfiguration).map(BlobStoreConfiguration::getType).filter(type -> StringUtils.equalsIgnoreCase((String)"Azure Cloud Storage", (String)type)).isPresent();
    }
}

