/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal;

import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.ws.rs.core.Response;

@Api(value="Blob store")
public interface AzureBlobStoreApiResourceDoc {
    @ApiOperation(value="Create an Azure blob store")
    @ApiResponses(value={@ApiResponse(code=201, message="Azure blob store created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response createBlobStore(@Valid AzureBlobStoreApiModel var1) throws Exception;

    @ApiOperation(value="Update an Azure blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Azure blob store updated"), @ApiResponse(code=400, message="Specified Azure blob store doesn't exist"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void updateBlobStore(@Valid AzureBlobStoreApiModel var1, @ApiParam(value="Name of the blob store to update") String var2) throws Exception;

    @ApiOperation(value="Get an Azure blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=AzureBlobStoreApiModel.class), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Specified Azure blob store doesn't exist")})
    public AzureBlobStoreApiModel getBlobStore(@ApiParam(value="Name of the blob store configuration to fetch") String var1);
}

