/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.rest.internal.AzureBlobStoreApiConfigurationMapper;
import com.sonatype.nexus.blobstore.azure.rest.internal.AzureBlobStoreApiModelMapper;
import com.sonatype.nexus.blobstore.azure.rest.internal.AzureBlobStoreApiResourceDoc;
import com.sonatype.nexus.blobstore.azure.rest.internal.AzureBlobStoreApiUpdateValidation;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiModel;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceUtil;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AzureBlobStoreApiResource
extends ComponentSupport
implements Resource,
AzureBlobStoreApiResourceDoc {
    private final AzureBlobStoreApiUpdateValidation azureBlobStoreApiUpdateValidation;
    private final BlobStoreManager blobStoreManager;
    private final ApplicationVersion applicationVersion;

    public AzureBlobStoreApiResource(BlobStoreManager blobStoreManager, AzureBlobStoreApiUpdateValidation validation, ApplicationVersion applicationVersion) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.azureBlobStoreApiUpdateValidation = (AzureBlobStoreApiUpdateValidation)Preconditions.checkNotNull((Object)validation);
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
    }

    @Override
    @POST
    @RequiresAuthentication
    @Path(value="/azure")
    @RequiresPermissions(value={"nexus:blobstores:create"})
    public Response createBlobStore(@Valid AzureBlobStoreApiModel request) throws Exception {
        if ("PRO".equals(this.applicationVersion.getEdition()) || "TRIAL".equals(this.applicationVersion.getEdition())) {
            BlobStoreConfiguration blobStoreConfiguration = AzureBlobStoreApiModelMapper.MODEL_MAPPER.apply(this.blobStoreManager.newConfiguration(), request);
            if (this.blobStoreManager.exists(request.getName())) {
                throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)(String.valueOf(request.getName()) + " is already used, must be unique (ignoring case)"), "application/json");
            }
            this.blobStoreManager.create(blobStoreConfiguration);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return Response.status((Response.Status)Response.Status.PAYMENT_REQUIRED).entity((Object)"Azure Blob Storage is a Pro only feature.").type("text/plain").build();
    }

    @Override
    @PUT
    @RequiresAuthentication
    @Path(value="/azure/{name}")
    @RequiresPermissions(value={"nexus:blobstores:update"})
    public void updateBlobStore(@Valid AzureBlobStoreApiModel request, @PathParam(value="name") String blobStoreName) throws Exception {
        this.azureBlobStoreApiUpdateValidation.validateUpdateRequest(request, blobStoreName);
        BlobStoreConfiguration blobStoreConfiguration = AzureBlobStoreApiModelMapper.MODEL_MAPPER.apply(this.blobStoreManager.newConfiguration(), request);
        ((Map)blobStoreConfiguration.getAttributes().get(AzureConfigurationConstants.CONFIG_KEY)).computeIfAbsent("accountKey", s -> ((Map)this.blobStoreManager.get(blobStoreName).getBlobStoreConfiguration().getAttributes().get(AzureConfigurationConstants.CONFIG_KEY)).get("accountKey"));
        this.blobStoreManager.update(blobStoreConfiguration);
    }

    @Override
    @GET
    @RequiresAuthentication
    @Path(value="/azure/{name}")
    @RequiresPermissions(value={"nexus:blobstores:read"})
    public AzureBlobStoreApiModel getBlobStore(@PathParam(value="name") String blobStoreName) {
        return this.fetchBlobStoreConfiguration(blobStoreName).orElseThrow(() -> BlobStoreResourceUtil.createBlobStoreNotFoundException((String)"Azure Cloud Storage", (String)blobStoreName));
    }

    private Optional<AzureBlobStoreApiModel> fetchBlobStoreConfiguration(String blobStoreName) {
        return Optional.ofNullable(this.blobStoreManager.get(blobStoreName)).map(BlobStore::getBlobStoreConfiguration).map(this::ensureBlobStoreTypeIsAzure).map(AzureBlobStoreApiConfigurationMapper.CONFIGURATION_MAPPER);
    }

    private BlobStoreConfiguration ensureBlobStoreTypeIsAzure(BlobStoreConfiguration configuration) {
        String type = configuration.getType();
        if (!StringUtils.equalsIgnoreCase((String)"Azure Cloud Storage", (String)type)) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format("Blob store %s is not an Azure blob store", configuration.getName()), "application/json");
        }
        return configuration;
    }
}

