/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.azure.rest.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.azure.internal.AzureConfigurationConstants;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiAuthentication;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiBucketConfiguration;
import com.sonatype.nexus.blobstore.azure.rest.internal.model.AzureBlobStoreApiModel;
import java.util.Objects;
import java.util.function.BiFunction;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.rapture.PasswordPlaceholder;

public final class AzureBlobStoreApiModelMapper {
    public static final BiFunction<BlobStoreConfiguration, AzureBlobStoreApiModel, BlobStoreConfiguration> MODEL_MAPPER = (initialConfig, model) -> {
        BlobStoreConfiguration blobStoreConfiguration = (BlobStoreConfiguration)Preconditions.checkNotNull((Object)initialConfig);
        AzureBlobStoreApiModel request = (AzureBlobStoreApiModel)Preconditions.checkNotNull((Object)model);
        blobStoreConfiguration.setName(request.getName());
        blobStoreConfiguration.setType("Azure Cloud Storage");
        AzureBlobStoreApiModelMapper.copyBucketConfiguration(model.getBucketConfiguration(), blobStoreConfiguration.attributes(AzureConfigurationConstants.CONFIG_KEY));
        AzureBlobStoreApiModelMapper.copySoftQuota(request.getSoftQuota(), blobStoreConfiguration.attributes("blobStoreQuotaConfig"));
        return blobStoreConfiguration;
    };

    private static void copyBucketConfiguration(AzureBlobStoreApiBucketConfiguration bucketConfiguration, NestedAttributesMap azureBucketAttributes) {
        AzureBlobStoreApiModelMapper.copyGeneralBucketSettings((AzureBlobStoreApiBucketConfiguration)Preconditions.checkNotNull((Object)bucketConfiguration), azureBucketAttributes);
        AzureBlobStoreApiModelMapper.copyAuthenticationBucketSettings(bucketConfiguration.getAuthentication(), azureBucketAttributes);
    }

    private static void copyGeneralBucketSettings(AzureBlobStoreApiBucketConfiguration bucket, NestedAttributesMap azureBucketAttributes) {
        azureBucketAttributes.set("accountName", Preconditions.checkNotNull((Object)bucket.getAccountName()));
        azureBucketAttributes.set("containerName", Preconditions.checkNotNull((Object)bucket.getContainerName()));
    }

    private static void copyAuthenticationBucketSettings(AzureBlobStoreApiAuthentication authentication, NestedAttributesMap azureBucketAttributes) {
        if (Objects.nonNull(authentication)) {
            azureBucketAttributes.set("authenticationMethod", Preconditions.checkNotNull((Object)authentication.getAuthenticationMethod()));
            if (Objects.nonNull(authentication.getAccountKey()) && PasswordPlaceholder.isNot((String)authentication.getAccountKey())) {
                azureBucketAttributes.set("accountKey", (Object)authentication.getAccountKey());
            }
        }
    }

    private static void copySoftQuota(BlobStoreApiSoftQuota softQuota, NestedAttributesMap softQuotaAttributes) {
        if (Objects.nonNull(softQuota)) {
            softQuotaAttributes.set("quotaType", Preconditions.checkNotNull((Object)softQuota.getType()));
            Long softQuotaLimit = (Long)Preconditions.checkNotNull((Object)softQuota.getLimit());
            softQuotaAttributes.set("quotaLimitBytes", (Object)softQuotaLimit);
        }
    }
}

